/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet104WindowItems
extends Packet {
    public int windowId;
    public ItemStack[] itemStack;

    public Packet104WindowItems() {
    }

    public Packet104WindowItems(int i, List list) {
        this.windowId = i;
        this.itemStack = new ItemStack[list.size()];
        for (int j = 0; j < this.itemStack.length; ++j) {
            ItemStack itemstack = (ItemStack)list.get(j);
            this.itemStack[j] = itemstack != null ? itemstack.copy() : null;
        }
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.windowId = datainputstream.readByte();
        int word0 = datainputstream.readShort();
        this.itemStack = new ItemStack[word0];
        for (int i = 0; i < word0; ++i) {
            short word1 = datainputstream.readShort();
            if (word1 < 0) continue;
            byte byte0 = datainputstream.readByte();
            short word2 = datainputstream.readShort();
            this.itemStack[i] = new ItemStack(word1, (int)byte0, (int)word2);
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(this.windowId);
        dataoutputstream.writeShort(this.itemStack.length);
        for (int i = 0; i < this.itemStack.length; ++i) {
            if (this.itemStack[i] == null) {
                dataoutputstream.writeShort(-1);
                continue;
            }
            dataoutputstream.writeShort((short)this.itemStack[i].itemID);
            dataoutputstream.writeByte((byte)this.itemStack[i].stackSize);
            dataoutputstream.writeShort((short)this.itemStack[i].getMetadata());
        }
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleWindowItems(this);
    }

    @Override
    public int getPacketSize() {
        return 3 + this.itemStack.length * 5;
    }
}

