/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet23VehicleSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public float pitch;
    public float yaw;
    public int field_28047_e;
    public int field_28046_f;
    public int field_28045_g;
    public int type;
    public int field_28044_i;
    public int arrowType;

    public Packet23VehicleSpawn() {
    }

    public Packet23VehicleSpawn(Entity entity, int i) {
        this(entity, i, 0);
    }

    public Packet23VehicleSpawn(Entity entity, int i, int j) {
        this.entityId = entity.entityId;
        this.xPosition = MathHelper.floor_double(entity.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entity.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entity.posZ * 32.0);
        this.pitch = entity.rotationPitch;
        this.yaw = entity.rotationYaw;
        this.type = i;
        this.field_28044_i = j;
        if (j > 0) {
            double d = entity.motionX;
            double d1 = entity.motionY;
            double d2 = entity.motionZ;
            double d3 = 3.9;
            if (d < -d3) {
                d = -d3;
            }
            if (d1 < -d3) {
                d1 = -d3;
            }
            if (d2 < -d3) {
                d2 = -d3;
            }
            if (d > d3) {
                d = d3;
            }
            if (d1 > d3) {
                d1 = d3;
            }
            if (d2 > d3) {
                d2 = d3;
            }
            this.field_28047_e = (int)(d * 8000.0);
            this.field_28046_f = (int)(d1 * 8000.0);
            this.field_28045_g = (int)(d2 * 8000.0);
        }
        if (entity instanceof EntityArrow) {
            this.arrowType = ((EntityArrow)entity).arrowType;
        }
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.type = datainputstream.readByte();
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.pitch = datainputstream.readFloat();
        this.yaw = datainputstream.readFloat();
        this.field_28044_i = datainputstream.readInt();
        if (this.field_28044_i > 0) {
            this.field_28047_e = datainputstream.readShort();
            this.field_28046_f = datainputstream.readShort();
            this.field_28045_g = datainputstream.readShort();
        }
        if (this.type == 60) {
            this.arrowType = datainputstream.readInt();
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        dataoutputstream.writeByte(this.type);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeFloat(this.pitch);
        dataoutputstream.writeFloat(this.yaw);
        dataoutputstream.writeInt(this.field_28044_i);
        if (this.field_28044_i > 0) {
            dataoutputstream.writeShort(this.field_28047_e);
            dataoutputstream.writeShort(this.field_28046_f);
            dataoutputstream.writeShort(this.field_28045_g);
        }
        if (this.type == 60 || this.type == 73) {
            dataoutputstream.writeInt(this.arrowType);
        }
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleVehicleSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 21 + this.field_28044_i <= 0 ? 0 : 6;
    }
}

