/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.Chunk;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.World;

public class Packet52MultiBlockChange
extends Packet {
    public int xPosition;
    public int zPosition;
    public short[] coordinateArray;
    public short[] typeArray;
    public byte[] metadataArray;
    public int size;

    public Packet52MultiBlockChange() {
        this.isChunkDataPacket = true;
    }

    public Packet52MultiBlockChange(int x, int z, short[] blocksToUpdate, int numBlocksToUpdate, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = x;
        this.zPosition = z;
        this.size = numBlocksToUpdate;
        this.coordinateArray = new short[numBlocksToUpdate];
        this.typeArray = new short[numBlocksToUpdate];
        this.metadataArray = new byte[numBlocksToUpdate];
        Chunk chunk = world.getChunkFromChunkCoords(x, z);
        for (int i = 0; i < numBlocksToUpdate; ++i) {
            int blockX = blocksToUpdate[i] >> 12 & 0xF;
            int blockY = blocksToUpdate[i] & 0xFF;
            int blockZ = blocksToUpdate[i] >> 8 & 0xF;
            this.coordinateArray[i] = blocksToUpdate[i];
            this.typeArray[i] = (short)chunk.getBlockID(blockX, blockY, blockZ);
            this.metadataArray[i] = (byte)chunk.getBlockMetadata(blockX, blockY, blockZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        int i;
        this.xPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.size = datainputstream.readShort() & 0xFFFF;
        this.coordinateArray = new short[this.size];
        this.typeArray = new short[this.size];
        this.metadataArray = new byte[this.size];
        for (i = 0; i < this.size; ++i) {
            this.coordinateArray[i] = datainputstream.readShort();
        }
        for (i = 0; i < this.size; ++i) {
            this.typeArray[i] = datainputstream.readShort();
        }
        datainputstream.readFully(this.metadataArray);
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        int i;
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeShort((short)this.size);
        for (i = 0; i < this.size; ++i) {
            dataoutputstream.writeShort(this.coordinateArray[i]);
        }
        for (i = 0; i < this.size; ++i) {
            dataoutputstream.writeShort(this.typeArray[i]);
        }
        dataoutputstream.write(this.metadataArray);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleMultiBlockChange(this);
    }

    @Override
    public int getPacketSize() {
        return 10 + this.size * 4;
    }
}

