/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.MCHash;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Path;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;

public class Pathfinder {
    private IBlockAccess worldMap;
    private Path path = new Path();
    private MCHash pointMap = new MCHash();
    private PathPoint[] pathOptions = new PathPoint[32];

    public Pathfinder(IBlockAccess iblockaccess) {
        this.worldMap = iblockaccess;
    }

    public PathEntity createEntityPathTo(Entity entity, Entity entity1, float f) {
        return this.createEntityPathTo(entity, entity1.posX, entity1.boundingBox.minY, entity1.posZ, f);
    }

    public PathEntity createEntityPathTo(Entity entity, int i, int j, int k, float f) {
        return this.createEntityPathTo(entity, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, f);
    }

    private PathEntity createEntityPathTo(Entity entity, double d, double d1, double d2, float f) {
        this.path.clearPath();
        this.pointMap.clearMap();
        PathPoint pathpoint = this.openPoint(MathHelper.floor_double(entity.boundingBox.minX), MathHelper.floor_double(entity.boundingBox.minY), MathHelper.floor_double(entity.boundingBox.minZ));
        PathPoint pathpoint1 = this.openPoint(MathHelper.floor_double(d - (double)(entity.width / 2.0f)), MathHelper.floor_double(d1), MathHelper.floor_double(d2 - (double)(entity.width / 2.0f)));
        PathPoint pathpoint2 = new PathPoint(MathHelper.floor_float(entity.width + 1.0f), MathHelper.floor_float(entity.height + 1.0f), MathHelper.floor_float(entity.width + 1.0f));
        PathEntity pathentity = this.addToPath(entity, pathpoint, pathpoint1, pathpoint2, f);
        return pathentity;
    }

    private PathEntity addToPath(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f) {
        pathpoint.totalPathDistance = 0.0f;
        pathpoint.distanceToTarget = pathpoint.distanceToNext = pathpoint.distanceTo(pathpoint1);
        this.path.clearPath();
        this.path.addPoint(pathpoint);
        PathPoint pathpoint3 = pathpoint;
        while (!this.path.isPathEmpty()) {
            PathPoint pathpoint4 = this.path.dequeue();
            if (pathpoint4.equals(pathpoint1)) {
                return this.createEntityPath(pathpoint, pathpoint1);
            }
            if (pathpoint4.distanceTo(pathpoint1) < pathpoint3.distanceTo(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.isFirst = true;
            int i = this.findPathOptions(entity, pathpoint4, pathpoint2, pathpoint1, f);
            for (int j = 0; j < i; ++j) {
                PathPoint pathpoint5 = this.pathOptions[j];
                float f1 = pathpoint4.totalPathDistance + pathpoint4.distanceTo(pathpoint5);
                if (pathpoint5.isAssigned() && !(f1 < pathpoint5.totalPathDistance)) continue;
                pathpoint5.previous = pathpoint4;
                pathpoint5.totalPathDistance = f1;
                pathpoint5.distanceToNext = pathpoint5.distanceTo(pathpoint1);
                if (pathpoint5.isAssigned()) {
                    this.path.changeDistance(pathpoint5, pathpoint5.totalPathDistance + pathpoint5.distanceToNext);
                    continue;
                }
                pathpoint5.distanceToTarget = pathpoint5.totalPathDistance + pathpoint5.distanceToNext;
                this.path.addPoint(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint) {
            return null;
        }
        return this.createEntityPath(pathpoint, pathpoint3);
    }

    private int findPathOptions(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f) {
        int i = 0;
        int j = 0;
        if (this.getVerticalOffset(entity, pathpoint.xCoord, pathpoint.yCoord + 1, pathpoint.zCoord, pathpoint1) == 1) {
            j = 1;
        }
        PathPoint pathpoint3 = this.getSafePoint(entity, pathpoint.xCoord, pathpoint.yCoord, pathpoint.zCoord + 1, pathpoint1, j);
        PathPoint pathpoint4 = this.getSafePoint(entity, pathpoint.xCoord - 1, pathpoint.yCoord, pathpoint.zCoord, pathpoint1, j);
        PathPoint pathpoint5 = this.getSafePoint(entity, pathpoint.xCoord + 1, pathpoint.yCoord, pathpoint.zCoord, pathpoint1, j);
        PathPoint pathpoint6 = this.getSafePoint(entity, pathpoint.xCoord, pathpoint.yCoord, pathpoint.zCoord - 1, pathpoint1, j);
        if (pathpoint3 != null && !pathpoint3.isFirst && pathpoint3.distanceTo(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.isFirst && pathpoint4.distanceTo(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.isFirst && pathpoint5.distanceTo(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.isFirst && pathpoint6.distanceTo(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint6;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity entity, int i, int j, int k, PathPoint pathpoint, int l) {
        PathPoint pathpoint1 = null;
        if (this.getVerticalOffset(entity, i, j, k, pathpoint) == 1) {
            pathpoint1 = this.openPoint(i, j, k);
        }
        if (pathpoint1 == null && l > 0 && this.getVerticalOffset(entity, i, j + l, k, pathpoint) == 1) {
            pathpoint1 = this.openPoint(i, j + l, k);
            j += l;
        }
        if (pathpoint1 != null) {
            int i1 = 0;
            int j1 = 0;
            while (j > 0 && (j1 = this.getVerticalOffset(entity, i, j - 1, k, pathpoint)) == 1) {
                if (++i1 >= 4) {
                    return null;
                }
                if (--j <= 0) continue;
                pathpoint1 = this.openPoint(i, j, k);
            }
            if (j1 == -2) {
                return null;
            }
        }
        return pathpoint1;
    }

    private final PathPoint openPoint(int i, int j, int k) {
        int l = PathPoint.func_22329_a(i, j, k);
        PathPoint pathpoint = (PathPoint)this.pointMap.lookup(l);
        if (pathpoint == null) {
            pathpoint = new PathPoint(i, j, k);
            this.pointMap.addKey(l, pathpoint);
        }
        return pathpoint;
    }

    private int getVerticalOffset(Entity entity, int i, int j, int k, PathPoint pathpoint) {
        for (int l = i; l < i + pathpoint.xCoord; ++l) {
            for (int i1 = j; i1 < j + pathpoint.yCoord; ++i1) {
                for (int j1 = k; j1 < k + pathpoint.zCoord; ++j1) {
                    int k1 = this.worldMap.getBlockId(l, i1, j1);
                    if (k1 <= 0) continue;
                    if (Block.blocksList[k1] instanceof BlockDoor) {
                        int l1 = this.worldMap.getBlockMetadata(l, i1, j1);
                        if (BlockDoor.isOpen(l1)) continue;
                        return 0;
                    }
                    Material material = Block.blocksList[k1].blockMaterial;
                    if (material.getIsSolid()) {
                        return 0;
                    }
                    if (material == Material.water) {
                        return -1;
                    }
                    if (material != Material.lava) continue;
                    return -2;
                }
            }
        }
        return 1;
    }

    private PathEntity createEntityPath(PathPoint pathpoint, PathPoint pathpoint1) {
        int i = 1;
        PathPoint pathpoint2 = pathpoint1;
        while (pathpoint2.previous != null) {
            ++i;
            pathpoint2 = pathpoint2.previous;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint3 = pathpoint1;
        apathpoint[--i] = pathpoint3;
        while (pathpoint3.previous != null) {
            pathpoint3 = pathpoint3.previous;
            apathpoint[--i] = pathpoint3;
        }
        return new PathEntity(apathpoint);
    }
}

