/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.PlayerController;
import net.minecraft.src.World;

public class PlayerControllerMP
extends PlayerController {
    protected NetClientHandler netHandler;
    protected int currentItem;

    public PlayerControllerMP(Minecraft minecraft, NetClientHandler netHandler) {
        super(minecraft);
        this.netHandler = netHandler;
    }

    @Override
    public boolean destroyBlock(int x, int y, int z, int side) {
        int id = this.mc.theWorld.getBlockId(x, y, z);
        boolean removed = super.destroyBlock(x, y, z, side);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(id, x, y, z, this.mc.thePlayer);
            if (item.stackSize == 0) {
                item.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return removed;
    }

    @Override
    protected void hitBlock(int x, int y, int z, int side) {
    }

    @Override
    public void sendStartDigPacket(int x, int y, int z, int side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(0, x, y, z, side));
    }

    @Override
    public void sendDestroyBlockPacket(int x, int y, int z, int side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(2, x, y, z, side));
    }

    @Override
    protected void syncCurrentPlayItem() {
        int i = this.mc.thePlayer.inventory.currentItem;
        if (i != this.currentItem) {
            this.currentItem = i;
            this.netHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentItem));
        }
    }

    @Override
    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l, double heightPlaced) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(i, j, k, l, entityplayer.inventory.getCurrentItem(), heightPlaced));
        boolean flag = super.activeBlockOrUseItem(entityplayer, world, itemstack, i, j, k, l, heightPlaced);
        return flag;
    }

    @Override
    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 255, entityplayer.inventory.getCurrentItem(), 0.0));
        boolean flag = super.sendUseItem(entityplayer, world, itemstack);
        return flag;
    }

    @Override
    public EntityPlayer createPlayer(World world) {
        return new EntityClientPlayerMP(this.mc, world, this.mc.session, this.netHandler);
    }

    @Override
    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    @Override
    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 0));
        entityplayer.useCurrentItemOnEntity(entity);
    }

    @Override
    public ItemStack itemPickUpFromInventory(int i, int j, int k, boolean shift, boolean control, EntityPlayer entityplayer) {
        short word0 = entityplayer.craftingInventory.func_20111_a(entityplayer.inventory);
        ItemStack itemstack = super.itemPickUpFromInventory(i, j, k, shift, control, entityplayer);
        this.netHandler.addToSendQueue(new Packet102WindowClick(i, j, k, shift, control, itemstack, word0));
        return itemstack;
    }

    @Override
    public void func_20086_a(int i, EntityPlayer entityplayer) {
        if (i == -9999) {
            return;
        }
    }
}

