/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class RecipeRepairable
implements IRecipe {
    public Item inItem;
    public Item repairMaterial;
    public ItemStack inItemStack;

    public RecipeRepairable(Item inItem, Item repairMaterial) {
        this.inItem = inItem;
        this.repairMaterial = repairMaterial;
        this.inItemStack = new ItemStack(inItem);
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int repairMaterialCount = 0;
        int inItemCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.repairMaterial.itemID) {
                    ++repairMaterialCount;
                    continue;
                }
                if (stack.itemID == this.inItem.itemID) {
                    ++inItemCount;
                    continue;
                }
                return false;
            }
        }
        if (repairMaterialCount == 0) {
            return false;
        }
        return inItemCount == 1;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        int repairMaterialCount = 0;
        ItemStack inItemStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.repairMaterial.itemID) {
                    ++repairMaterialCount;
                    continue;
                }
                if (stack.itemID != this.inItem.itemID) continue;
                inItemStack = stack.copy();
            }
        }
        for (int i = 0; i < repairMaterialCount; ++i) {
            if (inItemStack.getMetadata() >= inItemStack.getMaxDamage()) continue;
            inItemStack.setMetadata(inItemStack.getMetadata() - inItemStack.getMaxDamage() / 8);
        }
        if (inItemStack.getMetadata() < 0) {
            inItemStack.setMetadata(0);
        }
        return inItemStack;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                ItemStack stack2 = stack.stackSize - 1 == 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - 1);
                inventorycrafting.setSlotContentsAt(x, y, stack2);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.inItemStack;
    }
}

