/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class RecipeScrap
implements IRecipe {
    public Item itemToScrap;
    public Item scrapYield;
    public ItemStack scrapYieldStack;

    public RecipeScrap(Item itemToScrap, Item scrapYield) {
        this.itemToScrap = itemToScrap;
        this.scrapYield = scrapYield;
        this.scrapYieldStack = new ItemStack(scrapYield);
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int itemToScrapCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.itemToScrap.itemID) {
                    ++itemToScrapCount;
                    continue;
                }
                return false;
            }
        }
        return itemToScrapCount == true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        float itemToScrapDamage = 0.0f;
        float itemMaxDamage = 0.0f;
        Object scrapYieldStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null || stack.itemID != this.itemToScrap.itemID) continue;
                itemToScrapDamage = stack.getMetadata();
                itemMaxDamage = stack.getMaxDamage();
            }
        }
        float scrapYieldResult = (itemMaxDamage - itemToScrapDamage) / itemMaxDamage * 4.0f;
        if (scrapYieldResult >= 1.0f) {
            return new ItemStack(this.scrapYield, (int)scrapYieldResult);
        }
        return null;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                ItemStack stack2 = stack.stackSize - 1 == 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - 1);
                inventorycrafting.setSlotContentsAt(x, y, stack2);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.scrapYieldStack;
    }
}

