/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.CraftingManager;
import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.ItemStack;

public class RecipeShaped
implements IRecipe {
    public int recipeWidth;
    public int recipeHeight;
    public ItemStack[] recipeItems;
    public ItemStack recipeOutput;
    public boolean useAlternatives;
    public boolean countForMetadata;
    public final int recipeOutputItemID;

    public RecipeShaped(int i, int j, ItemStack[] aitemstack, ItemStack itemstack) {
        this.recipeOutputItemID = itemstack.itemID;
        this.recipeWidth = i;
        this.recipeHeight = j;
        this.recipeItems = aitemstack;
        this.recipeOutput = itemstack;
        this.useAlternatives = false;
        this.countForMetadata = true;
    }

    public RecipeShaped(int i, int j, ItemStack[] aitemstack, ItemStack itemstack, boolean useAlternatives, boolean countForMetadata) {
        this(i, j, aitemstack, itemstack);
        this.useAlternatives = useAlternatives;
        this.countForMetadata = countForMetadata;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.isRecipeMatching(inventorycrafting, i, j, true)) {
                    return true;
                }
                if (!this.isRecipeMatching(inventorycrafting, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRecipeMatching(InventoryCrafting inventorycrafting, int i, int j, boolean flag) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack itemstack1;
                int i1 = k - i;
                int j1 = l - j;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventorycrafting.getItemStackAt(k, l)) == null && itemstack == null) continue;
                int alternativeIndex = -1;
                if (this.useAlternatives && itemstack != null) {
                    for (int q = 0; q < CraftingManager.blockAlternatives.length; ++q) {
                        if (CraftingManager.blockAlternatives[q][0].blockID != itemstack.itemID) continue;
                        alternativeIndex = q;
                        break;
                    }
                }
                if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                    return false;
                }
                boolean idMatches = false;
                if (alternativeIndex != -1) {
                    for (int q = 0; q < CraftingManager.blockAlternatives[alternativeIndex].length; ++q) {
                        if (itemstack1.itemID != CraftingManager.blockAlternatives[alternativeIndex][q].blockID) continue;
                        idMatches = true;
                        break;
                    }
                } else if (itemstack.itemID == itemstack1.itemID) {
                    idMatches = true;
                }
                if (!idMatches) {
                    return false;
                }
                if (!this.countForMetadata || itemstack.getMetadata() == -1 || itemstack.getMetadata() == itemstack1.getMetadata()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getMetadata());
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < inventorycrafting.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inventorycrafting.getStackInSlot(i);
            if (itemstack1 == null) continue;
            inventorycrafting.decrStackSize(i, 1);
            if (!itemstack1.getItem().hasContainerItem()) continue;
            inventorycrafting.setInventorySlotContents(i, new ItemStack(itemstack1.getItem().getContainerItem()));
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

