/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.DownloadedTexture;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.ImageParser;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.dynamictexture.DynamicTextureCalendar;
import net.minecraft.src.dynamictexture.DynamicTextureClock;
import net.minecraft.src.dynamictexture.DynamicTextureCompass;
import net.minecraft.src.dynamictexture.DynamicTextureCustom;
import net.minecraft.src.dynamictexture.DynamicTextureFire;
import net.minecraft.src.dynamictexture.DynamicTextureLavaFlowing;
import net.minecraft.src.dynamictexture.DynamicTextureLavaStill;
import net.minecraft.src.dynamictexture.DynamicTexturePortal;
import net.minecraft.src.dynamictexture.DynamicTextureTrommel;
import net.minecraft.src.dynamictexture.DynamicTextureWaterFlow;
import net.minecraft.src.dynamictexture.DynamicTextureWaterStill;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.helper.Color;
import net.minecraft.src.helper.Colors;
import net.minecraft.src.helper.Textures;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public final Minecraft minecraft;
    private Map<String, Integer> textureMap = new HashMap<String, Integer>();
    private Map<String, int[]> intArrayTextureData = new HashMap<String, int[]>();
    private Map<Integer, BufferedImage> textureNameToImageMap = new HashMap<Integer, BufferedImage>();
    private Map<String, DownloadedTexture> downloadedTextures = new HashMap<String, DownloadedTexture>();
    private List<DynamicTexture> dynamicTextures = new ArrayList<DynamicTexture>();
    private GameSettings gameSettings;
    public TexturePackList texturePacks;
    private boolean clampTexture;
    private boolean blurTexture;

    public RenderEngine(Minecraft minecraft, TexturePackList texturePacks, GameSettings gameSettings) {
        this.minecraft = minecraft;
        this.clampTexture = false;
        this.blurTexture = false;
        this.texturePacks = texturePacks;
        this.gameSettings = gameSettings;
    }

    public void initDynamicTextures() {
        System.out.println("Initializing Dynamic Textures...");
        this.dynamicTextures.clear();
        GL11.glBindTexture(3553, this.getTexture("/terrain.png"));
        int terrainResolution = GL11.glGetTexLevelParameteri(3553, 0, 4096) / RenderEngine.atlasWidth();
        GL11.glBindTexture(3553, this.getTexture("/gui/items.png"));
        int itemsResolution = GL11.glGetTexLevelParameteri(3553, 0, 4096) / RenderEngine.atlasWidth();
        System.out.println("Resolution: Terrain: " + terrainResolution + " Items: " + itemsResolution);
        TextureFX.tileWidthTerrain = terrainResolution;
        TextureFX.tileWidthItems = itemsResolution;
        if ((Integer)this.minecraft.gameSettings.animations.value != 0) {
            boolean useCustomAnimations;
            boolean bl = useCustomAnimations = (Integer)this.minecraft.gameSettings.animations.value == 2;
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_still.png")) {
                System.out.println("Using Custom Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_still.png", Block.texCoordToIndex(13, 12), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_flowing.png")) {
                System.out.println("Using Custom Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_flowing.png", Block.texCoordToIndex(14, 12), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterFlow(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_still.png")) {
                System.out.println("Using Custom Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_still.png", Block.texCoordToIndex(13, 14), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_flowing.png")) {
                System.out.println("Using Custom Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_flowing.png", Block.texCoordToIndex(14, 14), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaFlowing(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_portal.png")) {
                System.out.println("Using Custom Portal Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_portal.png", Block.texCoordToIndex(14, 0), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Portal Animation");
                this.dynamicTextures.add(new DynamicTexturePortal(terrainResolution, false));
            }
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
            this.dynamicTextures.add(new DynamicTextureFire(terrainResolution));
        } else {
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
        }
        this.dynamicTextures.add(new DynamicTextureClock(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCalendar(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCompass(this.minecraft, itemsResolution));
    }

    public int[] getTextureImageData(String name) {
        int[] imageData = this.intArrayTextureData.get(name);
        if (imageData != null) {
            return imageData;
        }
        imageData = Textures.getImageData(Textures.readImage(this.texturePacks.selectedTexturePack.getResourceAsStream(name)));
        if (imageData == null) {
            imageData = Textures.getImageData(Textures.missingTexture);
        }
        this.intArrayTextureData.put(name, imageData);
        return imageData;
    }

    public boolean enableMipmapForTexture(String name) {
        return name.equals("/terrain.png") || name.equals("/gui/items.png");
    }

    public int getTexture(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        Integer id = this.textureMap.get(name);
        if (id != null) {
            return id;
        }
        try {
            id = GLAllocation.generateTexture();
            if (name.startsWith("##")) {
                this.setupTexture(Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(name.substring(2)))), (int)id);
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(7))), (int)id);
                this.clampTexture = false;
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(6))), (int)id);
                this.blurTexture = false;
            } else {
                InputStream inputstream = texturePack.getResourceAsStream(name);
                if (inputstream == null) {
                    this.setupTexture(Textures.missingTexture, (int)id);
                } else {
                    this.setupTexture(Textures.readImage(inputstream), id, this.enableMipmapForTexture(name));
                }
            }
            this.textureMap.put(name, id);
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            int j = GLAllocation.generateTexture();
            this.setupTexture(Textures.missingTexture, j);
            this.textureMap.put(name, j);
            return j;
        }
    }

    public int allocateAndSetupTexture(BufferedImage bufferedimage) {
        int i = GLAllocation.generateTexture();
        this.setupTexture(bufferedimage, i);
        this.textureNameToImageMap.put(i, bufferedimage);
        return i;
    }

    public void setupTexture(BufferedImage img, int id) {
        this.setupTexture(img, id, false);
    }

    public int[] getAverageTileColors(ByteBuffer buffer, int atlasSize, int res) {
        int[] tileColors = new int[atlasSize * atlasSize];
        int w = atlasSize * res;
        for (int tileX = 0; tileX < atlasSize; ++tileX) {
            for (int tileY = 0; tileY < atlasSize; ++tileY) {
                int r1 = 0;
                int g1 = 0;
                int b1 = 0;
                int a1 = 0;
                int co = 0;
                for (int i = 0; i < res; ++i) {
                    for (int j = 0; j < res; ++j) {
                        int k = (tileY * res + j) * w + (tileX * res + i);
                        int r = buffer.get(k * 4 + 0) & 0xFF;
                        int g = buffer.get(k * 4 + 1) & 0xFF;
                        int b = buffer.get(k * 4 + 2) & 0xFF;
                        int a = buffer.get(k * 4 + 3) & 0xFF;
                        if (a <= 0) continue;
                        r1 += r;
                        g1 += g;
                        b1 += b;
                        a1 += a;
                        ++co;
                    }
                }
                tileColors[tileY * atlasSize + tileX] = co > 0 ? Color.intToIntARGB(a1 /= co, r1 /= co, g1 /= co, b1 /= co) : 0;
            }
        }
        return tileColors;
    }

    public void setupTexture(BufferedImage img, int id, boolean mipmap) {
        GL11.glBindTexture(3553, id);
        if (this.blurTexture) {
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
        } else {
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
        } else {
            GL11.glTexParameteri(3553, 10242, 10497);
            GL11.glTexParameteri(3553, 10243, 10497);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Buffer.put(img);
        GL11.glTexImage2D(3553, 0, 6408, w, h, 0, 6408, 5121, Buffer.buffer);
        int atlasSize = net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        int res = w / atlasSize;
        if ((Integer)this.minecraft.gameSettings.mipmapLevels.value > 0 && mipmap && w == h) {
            Color color = new Color();
            Color tileColor = new Color();
            int levels = (Integer)this.minecraft.gameSettings.mipmapLevels.value;
            int[] tileColors = this.getAverageTileColors(Buffer.buffer, atlasSize, res);
            for (int level = 0; level <= levels; ++level) {
                int j;
                int i;
                Buffer.reset();
                int lod = (int)Math.pow(2.0, level);
                int res2 = res / lod;
                int w2 = w / lod;
                if (((Boolean)this.minecraft.gameSettings.mipmapSmooth.value).booleanValue()) {
                    for (i = 0; i < w2; ++i) {
                        for (j = 0; j < w2; ++j) {
                            int r1 = 0;
                            int g1 = 0;
                            int b1 = 0;
                            int a1 = 0;
                            int co = 0;
                            for (int i1 = 0; i1 < lod; ++i1) {
                                for (int j1 = 0; j1 < lod; ++j1) {
                                    color.setARGB(img.getRGB(i * lod + i1, j * lod + j1));
                                    int a = color.getAlpha();
                                    if (a <= 0) continue;
                                    r1 += color.getRed();
                                    g1 += color.getGreen();
                                    b1 += color.getBlue();
                                    a1 += a;
                                    ++co;
                                }
                            }
                            if (co > 0) {
                                color.setRGBA(r1 /= co, g1 /= co, b1 /= co, a1 /= co);
                            } else {
                                color.setRGBA(0, 0, 0, 0);
                            }
                            Buffer.putColor(j * w2 + i, color);
                        }
                    }
                } else {
                    for (i = 0; i < w2; ++i) {
                        for (j = 0; j < w2; ++j) {
                            Buffer.putARGB(j * w2 + i, img.getRGB(i * lod, j * lod));
                        }
                    }
                }
                for (int tileX = 0; tileX < atlasSize; ++tileX) {
                    for (int tileY = 0; tileY < atlasSize; ++tileY) {
                        tileColor.setARGB(tileColors[tileY * atlasSize + tileX]);
                        for (int i2 = 0; i2 < res2; ++i2) {
                            for (int j2 = 0; j2 < res2; ++j2) {
                                int k = (tileY * res2 + j2) * w2 + (tileX * res2 + i2);
                                color.setARGB(Buffer.getARGB(k));
                                if (color.getAlpha() != 0) continue;
                                color.setRGB(tileColor);
                                Buffer.putColor(k, color);
                            }
                        }
                    }
                }
                Buffer.buffer.position(0);
                Buffer.buffer.limit(w2 * w2 * 4);
                GL11.glTexImage2D(3553, level, 6408, w2, w2, 0, 6408, 5121, Buffer.buffer);
            }
            GL11.glTexParameteri(3553, 10241, 9986);
            GL11.glTexParameteri(3553, 10240, 9728);
            GL11.glTexParameteri(3553, 33085, levels);
        }
    }

    public void updateDynamicTexture(DynamicTexture texture) {
        texture.update();
        Buffer.checkBufferSize(texture.imageData.length);
        Buffer.reset();
        Buffer.buffer.put(texture.imageData);
        Buffer.buffer.position(0).limit(texture.imageData.length);
        GL11.glBindTexture(3553, this.getTexture(texture.getTextureName()));
        int res = texture.resolution;
        int tileX = texture.textureIndex % RenderEngine.atlasWidth();
        int tileY = texture.textureIndex / RenderEngine.atlasWidth();
        for (int i = 0; i < texture.tileWidth; ++i) {
            for (int j = 0; j < texture.tileHeight; ++j) {
                int x1 = (tileX + i) * res;
                int y1 = (tileY + j) * res;
                GL11.glTexSubImage2D(3553, 0, x1, y1, res, res, 6408, 5121, Buffer.buffer);
            }
        }
        if ((Integer)this.minecraft.gameSettings.mipmapLevels.value > 0) {
            int levels = GL11.glGetTexParameteri(3553, 33085);
            for (int level = 1; level <= levels; ++level) {
                int j;
                int i;
                int lod = (int)Math.pow(2.0, level);
                int res2 = res / lod;
                Buffer.reset();
                for (i = 0; i < res2; ++i) {
                    for (j = 0; j < res2; ++j) {
                        int k = j * lod * res + i * lod;
                        int l = j * res2 + i;
                        Buffer.buffer.put(l * 4 + 0, texture.imageData[k * 4 + 0]);
                        Buffer.buffer.put(l * 4 + 1, texture.imageData[k * 4 + 1]);
                        Buffer.buffer.put(l * 4 + 2, texture.imageData[k * 4 + 2]);
                        Buffer.buffer.put(l * 4 + 3, texture.imageData[k * 4 + 3]);
                    }
                }
                Buffer.buffer.position(0).limit(res2 * res2 * 4);
                for (i = 0; i < texture.tileWidth; ++i) {
                    for (j = 0; j < texture.tileHeight; ++j) {
                        int x1 = (tileX + i) * res;
                        int y1 = (tileY + j) * res;
                        GL11.glTexSubImage2D(3553, level, x1 / lod, y1 / lod, res2, res2, 6408, 5121, Buffer.buffer);
                    }
                }
            }
        }
    }

    public void func_28150_a(int[] imageData, int w, int h, int textureId) {
        GL11.glBindTexture(3553, textureId);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        if (this.blurTexture) {
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
        } else {
            GL11.glTexParameteri(3553, 10242, 10497);
            GL11.glTexParameteri(3553, 10243, 10497);
        }
        byte[] bytes = new byte[w * h * 4];
        for (int l = 0; l < imageData.length; ++l) {
            int i1 = imageData[l] >> 24 & 0xFF;
            int j1 = imageData[l] >> 16 & 0xFF;
            int k1 = imageData[l] >> 8 & 0xFF;
            int l1 = imageData[l] & 0xFF;
            if (this.gameSettings != null && ((Boolean)this.gameSettings.anaglyph.value).booleanValue()) {
                int i2 = (j1 * 30 + k1 * 59 + l1 * 11) / 100;
                int j2 = (j1 * 30 + k1 * 70) / 100;
                int k2 = (j1 * 30 + l1 * 70) / 100;
                j1 = i2;
                k1 = j2;
                l1 = k2;
            }
            bytes[l * 4 + 0] = (byte)j1;
            bytes[l * 4 + 1] = (byte)k1;
            bytes[l * 4 + 2] = (byte)l1;
            bytes[l * 4 + 3] = (byte)i1;
        }
        Buffer.buffer.clear();
        Buffer.buffer.put(bytes);
        Buffer.buffer.position(0).limit(bytes.length);
        GL11.glTexSubImage2D(3553, 0, 0, 0, w, h, 6408, 5121, Buffer.buffer);
    }

    public void deleteTexture(int i) {
        this.textureNameToImageMap.remove(i);
        GL11.glDeleteTextures(i);
    }

    public static int atlasWidth() {
        return net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public void updateDynamicTextures() {
        for (DynamicTexture dynamicTexture : this.dynamicTextures) {
            this.updateDynamicTexture(dynamicTexture);
        }
    }

    private int weightedAverageColor(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        int c = 255;
        if (k + l == 0) {
            k = 1;
            l = 1;
            c = 0;
        }
        int i1 = (i >> 16 & 0xFF) * k;
        int j1 = (i >> 8 & 0xFF) * k;
        int k1 = (i & 0xFF) * k;
        int l1 = (j >> 16 & 0xFF) * l;
        int i2 = (j >> 8 & 0xFF) * l;
        int j2 = (j & 0xFF) * l;
        int k2 = (i1 + l1) / (k + l);
        int l2 = (j1 + i2) / (k + l);
        int i3 = (k1 + j2) / (k + l);
        return c << 24 | k2 << 16 | l2 << 8 | i3;
    }

    public BufferedImage getImage(String name) {
        TexturePackBase pack = this.texturePacks.selectedTexturePack;
        try {
            BufferedImage img;
            if (name.startsWith("##")) {
                img = Textures.unwrapImageByColumns(Textures.readImage(pack.getResourceAsStream(name.substring(2))));
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(7)));
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(6)));
            } else {
                img = Textures.readImage(pack.getResourceAsStream(name));
            }
            return img;
        }
        catch (Exception e) {
            return Textures.missingTexture;
        }
    }

    public void setupTexture(String name, int id) {
        try {
            BufferedImage img = this.getImage(name);
            int j = this.textureMap.get(name);
            this.setupTexture(img, j, this.enableMipmapForTexture(name));
            this.blurTexture = false;
            this.clampTexture = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshTextures() {
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        this.textureNameToImageMap.forEach((i, img) -> this.setupTexture((BufferedImage)img, (int)i));
        this.textureMap.forEach((name, id) -> this.setupTexture((String)name, (int)id));
        for (String s : this.intArrayTextureData.keySet()) {
            try {
                BufferedImage img2;
                if (s.startsWith("##")) {
                    img2 = Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s.substring(7)));
                } else if (s.startsWith("%blur%")) {
                    this.blurTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s.substring(6)));
                } else {
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s));
                }
                Textures.getImageData(img2, this.intArrayTextureData.get(s));
                this.blurTexture = false;
                this.clampTexture = false;
            }
            catch (Exception ioexception1) {
                ioexception1.printStackTrace();
            }
        }
        this.initDynamicTextures();
        Colors.loadColors(texturePack);
        this.texturePacks.mc.fontRenderer = new FontRenderer(this.texturePacks.mc.gameSettings, "/font/default.png", this);
        Properties colors = new Properties();
        try {
            colors.load(texturePack.getResourceAsStream("/misc/colors.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ColorProperties.loadColors(colors);
    }

    public void bindTexture(int i) {
        if (i < 0) {
            return;
        }
        GL11.glBindTexture(3553, i);
    }

    public Map<String, Integer> getTextureMap() {
        return this.textureMap;
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        if (url == null) {
            if (localTexture != null) {
                this.bindTexture(this.getTexture(localTexture));
                return true;
            }
            return false;
        }
        DownloadedTexture texture = this.downloadedTextures.get(url);
        if (texture == null) {
            texture = new DownloadedTexture(url, imageParser);
            this.downloadedTextures.put(url, texture);
        }
        if (texture.textureId < 0 && texture.image != null) {
            texture.textureId = this.allocateAndSetupTexture(texture.image);
        }
        if (texture.textureId > 0) {
            this.bindTexture(texture.textureId);
            return true;
        }
        if (localTexture != null) {
            this.bindTexture(this.getTexture(localTexture));
            return true;
        }
        return false;
    }
}

