/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemQuiver;
import net.minecraft.src.ItemQuiverEndless;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.PlayerSkinParser;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold", "steel"};

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
    }

    protected boolean setArmorModel(EntityPlayer entityplayer, int i, float f) {
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3 - i);
        if (itemstack != null) {
            Item item = itemstack.getItem();
            if (item instanceof ItemArmor) {
                ItemArmor itemarmor = (ItemArmor)item;
                this.loadTexture("/armor/" + armorFilenamePrefix[itemarmor.material.renderIndex] + "_" + (i != 2 ? 1 : 2) + ".png");
                ModelBiped modelbiped = i != 2 ? this.modelArmorChestplate : this.modelArmor;
                modelbiped.bipedHead.showModel = i == 0;
                modelbiped.bipedHeadwear.showModel = i == 0;
                modelbiped.bipedBody.showModel = i == 1 || i == 2;
                modelbiped.bipedRightArm.showModel = i == 1;
                modelbiped.bipedLeftArm.showModel = i == 1;
                modelbiped.bipedRightLeg.showModel = i == 2 || i == 3;
                modelbiped.bipedLeftLeg.showModel = i == 2 || i == 3;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemQuiver) {
                this.loadTexture("/armor/quiver" + ".png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = i == 1 || i == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemQuiverEndless) {
                this.loadTexture("/armor/quiver_golden" + ".png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = i == 1 || i == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
        }
        return false;
    }

    public void renderPlayer(EntityPlayer entityplayer, double d, double d1, double d2, float f, float f1) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.modelBipedMain.field_1278_i = itemstack != null;
        this.modelArmor.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmorChestplate.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = entityplayer.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        double d3 = d1 - (double)entityplayer.yOffset;
        if (entityplayer.isSneaking() && !(entityplayer instanceof EntityPlayerSP)) {
            d3 -= 0.125;
        }
        super.doRenderLiving(entityplayer, d, d3, d2, f, f1);
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.field_1278_i = false;
        this.modelArmor.field_1278_i = false;
        this.modelArmorChestplate.field_1278_i = false;
    }

    protected void renderName(EntityPlayer entityplayer, double d, double d1, double d2) {
        if (Minecraft.getMinecraft().gameSettings.immersiveMode.drawNames() && this.renderManager.livingPlayer != null && entityplayer != this.renderManager.livingPlayer) {
            float f3;
            float f = 1.6f;
            float f1 = 0.01666667f * f;
            float f2 = entityplayer.getDistanceToEntity(this.renderManager.livingPlayer);
            float f4 = f3 = entityplayer.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entityplayer.getDisplayName();
                if (!entityplayer.isSneaking()) {
                    if (entityplayer.isPlayerSleeping()) {
                        this.renderLivingLabel(entityplayer, s, d, d1 - 1.5, d2, 64);
                    } else {
                        this.renderLivingLabel(entityplayer, s, d, d1, d2, 64);
                    }
                } else {
                    FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)d + 0.0f, (float)d1 + 2.3f, (float)d2);
                    GL11.glNormal3f(0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(-this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(this.renderManager.playerViewX, 1.0f, 0.0f, 0.0f);
                    GL11.glScalef(-f1, -f1, f1);
                    GL11.glDisable(2896);
                    GL11.glTranslatef(0.0f, 0.25f / f1, 0.0f);
                    GL11.glDepthMask(false);
                    GL11.glEnable(3042);
                    GL11.glBlendFunc(770, 771);
                    Tessellator tessellator = Tessellator.instance;
                    GL11.glDisable(3553);
                    tessellator.startDrawingQuads();
                    int i = fontrenderer.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i - 1, -1.0, 0.0);
                    tessellator.addVertex(-i - 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable(3553);
                    GL11.glDepthMask(true);
                    fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable(2896);
                    GL11.glDisable(3042);
                    GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void renderSpecials(EntityPlayer entityplayer, float f) {
        ItemStack itemstack1;
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3);
        if (itemstack != null && itemstack.getItem().itemID < Block.blocksList.length) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                float f1 = 0.625f;
                GL11.glTranslatef(0.0f, -0.25f, 0.0f);
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                GL11.glScalef(f1, -f1, f1);
            }
            this.renderManager.itemRenderer.renderItem(entityplayer, itemstack);
            GL11.glPopMatrix();
        }
        boolean renderCape = false;
        if (entityplayer.username.equals("MaggAndGeez") || entityplayer.username.equals("jonkadelic") || entityplayer.username.equals("Bestsoft100")) {
            renderCape = true;
            this.loadTexture("/armor/bta_cloak.png");
        } else {
            renderCape = this.loadDownloadableTexture(entityplayer.capeURL, null, null);
        }
        if (renderCape) {
            GL11.glPushMatrix();
            GL11.glTranslatef(0.0f, 0.0f, 0.125f);
            double d = entityplayer.field_20066_r + (entityplayer.field_20063_u - entityplayer.field_20066_r) * (double)f - (entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f);
            double d1 = entityplayer.field_20065_s + (entityplayer.field_20062_v - entityplayer.field_20065_s) * (double)f - (entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f);
            double d2 = entityplayer.field_20064_t + (entityplayer.field_20061_w - entityplayer.field_20064_t) * (double)f - (entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f);
            float f8 = entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f;
            double d3 = MathHelper.sin(f8 * 3.141593f / 180.0f);
            double d4 = -MathHelper.cos(f8 * 3.141593f / 180.0f);
            float f9 = (float)d1 * 10.0f;
            if (f9 < -6.0f) {
                f9 = -6.0f;
            }
            if (f9 > 32.0f) {
                f9 = 32.0f;
            }
            float f10 = (float)(d * d3 + d2 * d4) * 100.0f;
            float f11 = (float)(d * d4 - d2 * d3) * 100.0f;
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * f;
            f9 += MathHelper.sin((entityplayer.prevDistanceWalkedModified + (entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified) * f) * 6.0f) * 32.0f * f12;
            if (entityplayer.isSneaking()) {
                f9 += 25.0f;
            }
            GL11.glRotatef(6.0f + f10 / 2.0f + f9, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(f11 / 2.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(-f11 / 2.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = entityplayer.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef(-0.0625f, 0.4375f, 0.0625f);
            if (entityplayer.fishEntity != null) {
                itemstack1 = new ItemStack(Item.stick);
            }
            if (itemstack1.itemID < Block.blocksList.length && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack1.itemID].getRenderType())) {
                float f3 = 0.5f;
                GL11.glTranslatef(0.0f, 0.1875f, -0.3125f);
                GL11.glRotatef(20.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
                GL11.glScalef(f3 *= 0.75f, -f3, f3);
            } else if (Item.itemsList[itemstack1.itemID].isFull3D()) {
                float f4 = 0.625f;
                if (Item.itemsList[itemstack1.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
                    GL11.glTranslatef(0.0f, -0.125f, 0.0f);
                }
                if (Item.itemsList[itemstack1.itemID].shouldPointInFrontOfPlayer()) {
                    GL11.glRotatef(-20.0f, 0.0f, 1.0f, 0.0f);
                    GL11.glTranslatef(0.0f, -0.125f, 0.0f);
                }
                GL11.glTranslatef(0.0f, 0.1875f, 0.0f);
                GL11.glScalef(f4, -f4, f4);
                GL11.glRotatef(-100.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
            } else {
                float f5 = 0.375f;
                GL11.glTranslatef(0.25f, 0.1875f, -0.1875f);
                GL11.glScalef(f5, f5, f5);
                GL11.glRotatef(60.0f, 0.0f, 0.0f, 1.0f);
                GL11.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(20.0f, 0.0f, 0.0f, 1.0f);
            }
            this.renderManager.itemRenderer.renderItem(entityplayer, itemstack1);
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer entityplayer, float f) {
        float f1 = 0.9375f;
        GL11.glScalef(f1, f1, f1);
    }

    public void drawFirstPersonHand() {
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void func_22016_b(EntityPlayer entityplayer, double d, double d1, double d2) {
        if (entityplayer.isEntityAlive() && entityplayer.isPlayerSleeping()) {
            super.func_22012_b(entityplayer, d + (double)entityplayer.field_22063_x, d1 + (double)entityplayer.field_22062_y, d2 + (double)entityplayer.field_22061_z);
        } else {
            super.func_22012_b(entityplayer, d, d1, d2);
        }
    }

    protected void func_22017_a(EntityPlayer entityplayer, float f, float f1, float f2) {
        if (entityplayer.isEntityAlive() && entityplayer.isPlayerSleeping()) {
            GL11.glRotatef(entityplayer.getBedOrientationInDegrees(), 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.getDeathMaxRotation(entityplayer), 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(270.0f, 0.0f, 1.0f, 0.0f);
        } else {
            super.rotateCorpse(entityplayer, f, f1, f2);
        }
    }

    @Override
    protected void passSpecialRender(EntityLiving entityliving, double d, double d1, double d2) {
        this.renderName((EntityPlayer)entityliving, d, d1, d2);
    }

    @Override
    protected void preRenderCallback(EntityLiving entityliving, float f) {
        this.func_186_b((EntityPlayer)entityliving, f);
    }

    @Override
    protected boolean shouldRenderPass(EntityLiving entityliving, int i, float f) {
        return this.setArmorModel((EntityPlayer)entityliving, i, f);
    }

    @Override
    protected void renderEquippedItems(EntityLiving entityliving, float f) {
        this.renderSpecials((EntityPlayer)entityliving, f);
    }

    @Override
    protected void rotateCorpse(EntityLiving entityliving, float f, float f1, float f2) {
        this.func_22017_a((EntityPlayer)entityliving, f, f1, f2);
    }

    @Override
    protected void func_22012_b(EntityLiving entityliving, double d, double d1, double d2) {
        this.func_22016_b((EntityPlayer)entityliving, d, d1, d2);
    }

    @Override
    public void doRenderLiving(EntityLiving entityliving, double d, double d1, double d2, float f, float f1) {
        this.renderPlayer((EntityPlayer)entityliving, d, d1, d2, f, f1);
    }

    @Override
    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.renderPlayer((EntityPlayer)entity, d, d1, d2, f, f1);
    }

    @Override
    public void loadEntityTexture(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            this.loadDownloadableTexture(((EntityPlayer)entityLiving).skinURL, entityLiving.getEntityTexture(), PlayerSkinParser.instance);
        } else {
            super.loadEntityTexture(entityLiving);
        }
    }
}

