/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.minecraft.src.ChunkFile;
import net.minecraft.src.ChunkFilePattern;
import net.minecraft.src.ChunkFolderPattern;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RegionFile;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveFormatOld;
import net.minecraft.src.SaveOldDirClient;
import net.minecraft.src.WorldInfo;

public class SaveFormatMcRegion
extends SaveFormatOld {
    public SaveFormatMcRegion(File file) {
        super(file);
    }

    @Override
    public String getFormatName() {
        return "Scaevolus' McRegion";
    }

    @Override
    public List getSaveList() {
        File[] afile;
        ArrayList<SaveFormatComparator> arraylist = new ArrayList<SaveFormatComparator>();
        for (File file : afile = this.saveDir.listFiles()) {
            String s;
            WorldInfo worldinfo;
            if (!file.isDirectory() || (worldinfo = this.getWorldInfo(s = file.getName())) == null) continue;
            boolean needsConversion = worldinfo.getSaveVersion() != 19132;
            String s1 = worldinfo.getWorldName();
            if (s1 == null || MathHelper.stringNullOrLengthZero(s1)) {
                s1 = s;
            }
            arraylist.add(new SaveFormatComparator(s, s1, worldinfo, worldinfo.getLastTimePlayed(), worldinfo.getSizeOnDisk(), needsConversion));
        }
        return arraylist;
    }

    @Override
    public void flushCache() {
        RegionFileCache.func_22192_a();
    }

    @Override
    public ISaveHandler getSaveLoader(String s, boolean flag) {
        return new SaveOldDirClient(this.saveDir, s, flag);
    }

    @Override
    public boolean isOldMapFormat(String s) {
        WorldInfo worldinfo = this.getWorldInfo(s);
        return worldinfo != null && worldinfo.getSaveVersion() == 0;
    }

    @Override
    public boolean convertMapFormat(String s, IProgressUpdate iprogressupdate) {
        iprogressupdate.setLoadingProgress(0);
        ArrayList arraylist = new ArrayList();
        ArrayList arraylist1 = new ArrayList();
        ArrayList arraylist2 = new ArrayList();
        ArrayList arraylist3 = new ArrayList();
        File file = new File(this.saveDir, s);
        File file1 = new File(file, "DIM-1");
        System.out.println("Scanning folders...");
        this.getOldFormatFolders(file, arraylist, arraylist1);
        if (file1.exists()) {
            this.getOldFormatFolders(file1, arraylist2, arraylist3);
        }
        int i = arraylist.size() + arraylist2.size() + arraylist1.size() + arraylist3.size();
        System.out.println("Total conversion count is " + i);
        this.func_22181_a(file, arraylist, 0, i, iprogressupdate);
        this.func_22181_a(file1, arraylist2, arraylist.size(), i, iprogressupdate);
        WorldInfo worldinfo = this.getWorldInfo(s);
        worldinfo.setSaveVersion(19132);
        ISaveHandler isavehandler = this.getSaveLoader(s, false);
        isavehandler.saveWorldInfo(worldinfo);
        this.func_22182_a(arraylist1, arraylist.size() + arraylist2.size(), i, iprogressupdate);
        if (file1.exists()) {
            this.func_22182_a(arraylist3, arraylist.size() + arraylist2.size() + arraylist1.size(), i, iprogressupdate);
        }
        return true;
    }

    private void getOldFormatFolders(File file, ArrayList arraylist, ArrayList arraylist1) {
        File[] afile;
        ChunkFolderPattern chunkfolderpattern = new ChunkFolderPattern(null);
        ChunkFilePattern chunkfilepattern = new ChunkFilePattern(null);
        for (File file1 : afile = file.listFiles(chunkfolderpattern)) {
            File[] afile2;
            arraylist1.add(file1);
            for (File file2 : afile2 = file1.listFiles(chunkfolderpattern)) {
                File[] afile4;
                for (File file3 : afile4 = file2.listFiles(chunkfilepattern)) {
                    arraylist.add(new ChunkFile(file3));
                }
            }
        }
    }

    private void func_22181_a(File file, ArrayList arraylist, int i, int j, IProgressUpdate iprogressupdate) {
        Collections.sort(arraylist);
        byte[] abyte0 = new byte[4096];
        for (ChunkFile chunkfile : arraylist) {
            int l;
            int k = chunkfile.func_22323_b();
            RegionFile regionfile = RegionFileCache.func_22193_a(file, k, l = chunkfile.func_22321_c());
            if (!regionfile.func_22202_c(k & 0x1F, l & 0x1F)) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkfile.func_22324_a())));
                    DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(k & 0x1F, l & 0x1F);
                    int j1 = 0;
                    while ((j1 = datainputstream.read(abyte0)) != -1) {
                        dataoutputstream.write(abyte0, 0, j1);
                    }
                    dataoutputstream.close();
                    datainputstream.close();
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                }
            }
            int i1 = (int)Math.round(100.0 * (double)(++i) / (double)j);
            iprogressupdate.setLoadingProgress(i1);
        }
        RegionFileCache.func_22192_a();
    }

    private void func_22182_a(ArrayList arraylist, int i, int j, IProgressUpdate iprogressupdate) {
        for (File file : arraylist) {
            File[] afile = file.listFiles();
            SaveFormatMcRegion.deleteFiles(afile);
            file.delete();
            int k = (int)Math.round(100.0 * (double)(++i) / (double)j);
            iprogressupdate.setLoadingProgress(k);
        }
    }
}

