/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.InputStream;
import java.util.Properties;

public class StringTranslate {
    private static StringTranslate instance = new StringTranslate();
    private Properties translateTable = new Properties();

    private StringTranslate() {
        try {
            InputStream stream = StringTranslate.class.getResourceAsStream("/lang/en_US.lang");
            this.translateTable.load(stream);
            stream.close();
            stream = StringTranslate.class.getResourceAsStream("/lang/stats_US.lang");
            this.translateTable.load(stream);
            stream.close();
        }
        catch (Exception ioexception) {
            ioexception.printStackTrace();
        }
        System.out.println(this.translateTable.size() + " Translation Keys");
    }

    public static StringTranslate getInstance() {
        return instance;
    }

    public String translateKey(String s) {
        if (s == null) {
            return null;
        }
        String translated = this.translateTable.getProperty(s);
        if (translated == null) {
            System.err.println("Missing translation: " + s + "\n at " + Thread.currentThread().getStackTrace()[2]);
            return s;
        }
        return translated;
    }

    public String translateKeyFormat(String s, Object[] aobj) {
        String s1 = this.translateTable.getProperty(s, s);
        return String.format(s1, aobj);
    }

    public String translateNamedKey(String s) {
        return this.translateTable.getProperty(s + ".name", s);
    }

    public String translateKeyDescription(String s) {
        return this.translateTable.getProperty(s + ".desc", "");
    }
}

