/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockFurnace;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.LookupFuelFurnace;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.RecipesFurnace;
import net.minecraft.src.TileEntity;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    protected ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int maxBurnTime = 0;
    public int currentCookTime = 0;
    protected int maxCookTime = 200;
    protected int currentBurnTime = 0;

    @Override
    public int getSizeInventory() {
        return this.furnaceItemStacks.length;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.furnaceItemStacks[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.furnaceItemStacks[i] != null) {
            if (this.furnaceItemStacks[i].stackSize <= j) {
                ItemStack itemstack = this.furnaceItemStacks[i];
                this.furnaceItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.furnaceItemStacks[i].splitStack(j);
            if (this.furnaceItemStacks[i].stackSize == 0) {
                this.furnaceItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.furnaceItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Furnace";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if (byte0 < 0 || byte0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[byte0] = new ItemStack(nbttagcompound1);
        }
        this.currentBurnTime = nbttagcompound.getShort("BurnTime");
        this.currentCookTime = nbttagcompound.getShort("CookTime");
        this.maxBurnTime = nbttagcompound.getShort("MaxBurnTime");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setShort("BurnTime", (short)this.currentBurnTime);
        nbttagcompound.setShort("CookTime", (short)this.currentCookTime);
        nbttagcompound.setShort("MaxBurnTime", (short)this.maxBurnTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.furnaceItemStacks[i].writeToNBT(nbttagcompound1);
            nbttaglist.setTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int getCookProgressScaled(int i) {
        if (this.maxCookTime == 0) {
            return 0;
        }
        return this.currentCookTime * i / this.maxCookTime;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.maxBurnTime == 0) {
            return 0;
        }
        return this.currentBurnTime * i / this.maxBurnTime;
    }

    public boolean isBurning() {
        return this.currentBurnTime > 0;
    }

    @Override
    public void updateEntity() {
        boolean isBurnTimeHigherThan0 = this.currentBurnTime > 0;
        boolean furnaceUpdated = false;
        if (this.currentBurnTime > 0) {
            --this.currentBurnTime;
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.furnaceStoneIdle.blockID && this.currentBurnTime == 0 && this.furnaceItemStacks[0] == null && this.furnaceItemStacks[1] != null && this.furnaceItemStacks[1].itemID == Block.netherrack.blockID) {
                --this.furnaceItemStacks[1].stackSize;
                if (this.furnaceItemStacks[1].stackSize == 0) {
                    this.furnaceItemStacks[1] = null;
                }
                BlockFurnace.updateFurnaceBlockState(true, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                furnaceUpdated = true;
            }
            if (this.currentBurnTime == 0 && this.canSmelt()) {
                this.maxBurnTime = this.currentBurnTime = this.getBurnTimeFromItem(this.furnaceItemStacks[1]);
                if (this.currentBurnTime > 0) {
                    furnaceUpdated = true;
                    if (this.furnaceItemStacks[1] != null) {
                        if (this.furnaceItemStacks[1].getItem() == Item.bucketLava) {
                            this.furnaceItemStacks[1] = new ItemStack(Item.bucket);
                        } else {
                            --this.furnaceItemStacks[1].stackSize;
                            if (this.furnaceItemStacks[1].stackSize == 0) {
                                this.furnaceItemStacks[1] = null;
                            }
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.currentCookTime;
                if (this.currentCookTime == this.maxCookTime) {
                    this.currentCookTime = 0;
                    this.smeltItem();
                    furnaceUpdated = true;
                }
            } else {
                this.currentCookTime = 0;
            }
            if (isBurnTimeHigherThan0 != this.currentBurnTime > 0) {
                furnaceUpdated = true;
                this.updateFurnace();
            }
        }
        if (furnaceUpdated) {
            this.onInventoryChanged();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = RecipesFurnace.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().itemID);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].isItemEqual(itemstack)) {
            return false;
        }
        if (this.furnaceItemStacks[2].stackSize < this.getInventoryStackLimit() && this.furnaceItemStacks[2].stackSize < this.furnaceItemStacks[2].getMaxStackSize()) {
            return true;
        }
        return this.furnaceItemStacks[2].stackSize < itemstack.getMaxStackSize();
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = RecipesFurnace.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().itemID);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = itemstack.copy();
        } else if (this.furnaceItemStacks[2].itemID == itemstack.itemID) {
            ++this.furnaceItemStacks[2].stackSize;
        }
        --this.furnaceItemStacks[0].stackSize;
        if (this.furnaceItemStacks[0].stackSize <= 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    protected void updateFurnace() {
        BlockFurnace.updateFurnaceBlockState(this.currentBurnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    private int getBurnTimeFromItem(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return LookupFuelFurnace.fuelFurnace().getFuelYield(itemStack.getItem().itemID);
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }
}

