/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSensor;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class TileEntitySensor
extends TileEntity {
    public TileEntitySensor() {
        Random rand = new Random();
    }

    public String getInvName() {
        return "Sensor";
    }

    private boolean canSeeInFront(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 2 && !world.isBlockOpaqueCube(x, y, z - 1)) {
            return true;
        }
        if (metadata == 3 && !world.isBlockOpaqueCube(x, y, z + 1)) {
            return true;
        }
        if (metadata == 4 && !world.isBlockOpaqueCube(x - 1, y, z)) {
            return true;
        }
        return metadata == 5 && !world.isBlockOpaqueCube(x + 1, y, z);
    }

    private AxisAlignedBB getDetectionRadius(int x, int y, int z, int metadata) {
        if (metadata == 2) {
            return AxisAlignedBB.getBoundingBoxFromPool(x, y, z - 2, x + 1, (float)y + 1.0f, z + 1);
        }
        if (metadata == 3) {
            return AxisAlignedBB.getBoundingBoxFromPool(x, y, z, x + 1, (float)y + 1.0f, z + 3);
        }
        if (metadata == 4) {
            return AxisAlignedBB.getBoundingBoxFromPool(x - 2, y, z, x + 1, (float)y + 1.0f, z + 1);
        }
        return AxisAlignedBB.getBoundingBoxFromPool(x, y, z, x + 3, (float)y + 1.0f, z + 1);
    }

    @Override
    public void updateEntity() {
        if (!this.worldObj.isMultiplayerAndNotHost) {
            List<Entity> list;
            boolean shouldBeActive = false;
            int metadata = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            if (this.canSeeInFront(this.worldObj, this.xCoord, this.yCoord, this.zCoord) && (list = this.worldObj.getEntitiesWithinAABB(Entity.class, this.getDetectionRadius(this.xCoord, this.yCoord, this.zCoord, metadata))).size() > 0) {
                for (Entity e : list) {
                    Entity entity = e;
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).triggerAchievement(AchievementList.getSensed);
                }
                shouldBeActive = true;
            }
            if (shouldBeActive && this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) != Block.motionsensorActive.blockID) {
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.breath", 0.5f, this.worldObj.rand.nextFloat());
                BlockSensor.updateSensorBlockState(true, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
            if (!shouldBeActive && this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) != Block.motionsensorIdle.blockID) {
                BlockSensor.updateSensorBlockState(false, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }
}

