/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class WeatherClear
extends Weather {
    protected double[] generatedTemperatures;

    public WeatherClear(int id) {
        super(id);
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        if (world.getCurrentSeason() != null && !world.getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        if (rand.nextInt(4) == 0) {
            int y = world.getHeightValue(x, z);
            int blockId = world.getBlockId(x, y, z);
            int blockIdBelow = world.getBlockId(x, y - 1, z);
            if (world.getWorldChunkManager().getBiomeGenAt(x, z).hasSurfaceSnow()) {
                int meta;
                if (blockId == Block.layerSnow.blockID && (meta = world.getBlockMetadata(x, y, z)) != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                }
            } else if (blockId == Block.layerSnow.blockID) {
                int meta = world.getBlockMetadata(x, y, z);
                if (meta != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                } else {
                    world.setBlockWithNotify(x, y, z, 0);
                }
            } else if (blockIdBelow == Block.ice.blockID) {
                world.setBlockWithNotify(x, y - 1, z, Block.fluidWaterStill.blockID);
            }
        }
    }
}

