/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.NoiseGeneratorOctaves2;
import net.minecraft.src.World;

public class WorldChunkManager {
    protected NoiseGeneratorOctaves2 field_4194_e;
    protected NoiseGeneratorOctaves2 field_4193_f;
    protected NoiseGeneratorOctaves2 field_4192_g;
    public double[] temperature;
    public double[] humidity;
    public double[] biomeTemperature;
    public double[] biomeHumidity;
    public double[] fuzziness;
    public BiomeGenBase[] field_4195_d;
    protected World worldObj;

    protected WorldChunkManager() {
    }

    public WorldChunkManager(World world) {
        this.worldObj = world;
        this.field_4194_e = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 9871L), 4);
        this.field_4193_f = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 39811L), 4);
        this.field_4192_g = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 543321L), 2);
    }

    public BiomeGenBase getBiomeGenAtChunkCoord(ChunkCoordIntPair chunkcoordintpair) {
        return this.getBiomeGenAt(chunkcoordintpair.chunkXPos << 4, chunkcoordintpair.chunkZPos << 4);
    }

    public BiomeGenBase getBiomeGenAt(int i, int j) {
        BiomeGenBase b = this.worldObj.getBlockBiome(i, j);
        if (b == null) {
            b = this.func_4069_a(i, j, 1, 1)[0];
            this.worldObj.setBlockBiome(i, j, b);
        }
        return b;
    }

    public double getTemperature(int i, int j) {
        double t = this.worldObj.getBlockTemperature(i, j);
        if (t == Double.NEGATIVE_INFINITY) {
            this.func_4069_a(i, j, 1, 1);
            t = this.temperature[0];
            this.worldObj.setBlockTemperature(i, j, t);
        }
        return t;
    }

    public double getHumidity(int i, int j) {
        double h = this.worldObj.getBlockHumidity(i, j);
        if (h == Double.NEGATIVE_INFINITY) {
            this.func_4069_a(i, j, 1, 1);
            h = this.humidity[0];
            this.worldObj.setBlockHumidity(i, j, h);
        }
        return h;
    }

    public BiomeGenBase[] func_4069_a(int i, int j, int k, int l) {
        this.field_4195_d = this.loadBlockGeneratorData(this.field_4195_d, i, j, k, l);
        return this.field_4195_d;
    }

    public double[] getTemperatures(double[] ad, int i, int j, int k, int l) {
        if (ad == null || ad.length < k * l) {
            ad = new double[k * l];
        }
        int i1 = 0;
        for (int x = 0; x < k; ++x) {
            for (int z = 0; z < l; ++z) {
                ad[i1++] = this.getTemperature(i + x, j + z);
            }
        }
        return ad;
    }

    public BiomeGenBase[] updateBlockGeneratorDataFromHeight(BiomeGenBase[] abiomegenbase, int[] heights, int oceanHeight, int maxTerrainHeight, int x, int y, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x, y, width, width, 0.025, 0.025, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x, y, width, width, 0.05, 0.05, 0.3);
        this.biomeTemperature = this.field_4194_e.func_4112_a(this.biomeTemperature, x, y, width, width, 0.00625, 0.00625, 0.25);
        this.biomeHumidity = this.field_4193_f.func_4112_a(this.biomeHumidity, x, y, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x, y, width, length, 0.25, 0.25, 0.5);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                int terrainHeight = heights[j1 * 16 + k1];
                int aboveOceanHeight = maxTerrainHeight - oceanHeight;
                int aboveOceanTerrainHeight = terrainHeight - oceanHeight;
                float modifier = aboveOceanTerrainHeight <= 0 ? 1.0f : (float)aboveOceanTerrainHeight / (float)aboveOceanHeight;
                double d = this.fuzziness[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d2 + d * d1;
                d3 *= (double)modifier;
                d1 = 0.002;
                d2 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d2 + d * d1;
                d4 *= (double)modifier;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }

    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] abiomegenbase, int x, int z, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x, z, width, width, 0.025, 0.025, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x, z, width, width, 0.05, 0.05, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x, z, width, length, 0.25, 0.25, 0.5);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                double d = this.fuzziness[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d2 + d * d1;
                d1 = 0.002;
                d2 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d2 + d * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }
}

