/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenFlotsam
extends WorldGenerator {
    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        int blockId;
        int val;
        int rz;
        int rx;
        int topYUnderwater;
        int topY = world.findTopSolidBlock(x, z) - 1;
        if (topY == (topYUnderwater = world.findTopSolidNonLiquidBlock(x, z) - 1)) {
            return false;
        }
        if (topY < topYUnderwater + 4) {
            return false;
        }
        for (rx = -8; rx <= 8; ++rx) {
            for (rz = -8; rz <= 8; ++rz) {
                int r = 256;
                if (rx < -5 || rx > 5 || rz < -5 || rz > 5) {
                    r *= 3;
                }
                val = random.nextInt(r);
                blockId = 0;
                if (val < 16) {
                    blockId = Block.planksOak.blockID;
                } else if (val < 20) {
                    blockId = Block.logOak.blockID;
                } else if (val < 22) {
                    blockId = Block.glass.blockID;
                } else if (val < 26) {
                    blockId = Block.wool.blockID;
                } else if (val < 28) {
                    blockId = Block.bookshelfPlanksOak.blockID;
                } else if (val < 29) {
                    blockId = Block.workbench.blockID;
                } else if (val < 30) {
                    blockId = Block.jukebox.blockID;
                }
                if (blockId == 0) continue;
                world.setBlockWithNotify(x + rx, topY, z + rz, blockId);
            }
        }
        for (rx = -8; rx <= 8; ++rx) {
            for (rz = -8; rz <= 8; ++rz) {
                int id = world.getBlockId(x + rx, topY, z + rz);
                if (id == Block.fluidWaterStill.blockID || id == Block.fluidWaterFlowing.blockID) continue;
                val = random.nextInt(32);
                blockId = 0;
                if (val < 1) {
                    blockId = Block.stairsPlanksOak.blockID;
                } else if (val >= 2) {
                    if (val < 3) {
                        blockId = Block.torchCoal.blockID;
                    } else if (val < 4) {
                        blockId = Block.fencePlanksOak.blockID;
                    } else if (val >= 5) {
                        if (val < 6) {
                            blockId = Block.pressureplateStone.blockID;
                        } else if (val < 7) {
                            blockId = Block.pressureplatePlanksOak.blockID;
                        } else if (val < 8) {
                            blockId = Block.pressureplateCobbleStone.blockID;
                        } else if (val < 9) {
                            blockId = Block.torchRedstoneActive.blockID;
                        }
                    }
                }
                if (blockId == 0) continue;
                world.setBlockWithNotify(x + rx, topY + 1, z + rz, blockId);
            }
        }
        int chestX = x + (random.nextInt(16) - 8);
        int chestZ = z + (random.nextInt(16) - 8);
        world.setBlockWithNotify(chestX, topY, chestZ, Block.chestPlanksOak.blockID);
        this.doChestLoot((TileEntityChest)world.getBlockTileEntity(chestX, topY, chestZ), random);
        return true;
    }

    protected void doChestLoot(TileEntityChest entity, Random random) {
        for (int count = 0; count < 8; ++count) {
            ItemStack itemstack = this.pickChestLootItem(random);
            if (itemstack == null) continue;
            entity.setInventorySlotContents(random.nextInt(entity.getSizeInventory()), itemstack);
        }
    }

    private ItemStack pickChestLootItem(Random random) {
        int i = random.nextInt(14);
        if (i == 0) {
            return new ItemStack(Item.saddle);
        }
        if (i == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.foodBread);
        }
        if (i == 3) {
            return new ItemStack(Item.wheat, random.nextInt(4) + 1);
        }
        if (i == 4) {
            return new ItemStack(Item.sulphur, random.nextInt(4) + 1);
        }
        if (i == 5) {
            return new ItemStack(Item.string, random.nextInt(4) + 1);
        }
        if (i == 6) {
            return new ItemStack(Item.bucket);
        }
        if (i == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.foodAppleGold);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.dustRedstone, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(9)]);
        }
        if (i == 10) {
            return new ItemStack(Item.dye, 1, 3);
        }
        if (i == 11) {
            return new ItemStack(Item.itemsList[Block.spongeDry.blockID], random.nextInt(4) + 1);
        }
        if (i == 12) {
            return new ItemStack(Item.bone, random.nextInt(4) + 1);
        }
        if (i == 13) {
            return new ItemStack(Item.foodApple);
        }
        return null;
    }
}

