/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;

public class ClearCommand
extends Command {
    public ClearCommand() {
        super("clear", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int i;
        EntityPlayer player = null;
        if (args.length == 0) {
            player = sender.getPlayer();
        }
        if (args.length == 1) {
            player = handler.getPlayer(args[0]);
        }
        if (player == null) {
            throw new CommandError("Must be used by a player, or define a player name!");
        }
        for (i = 0; i < player.inventory.getSizeInventory(); ++i) {
            player.inventory.setInventorySlotContents(i, null);
        }
        for (i = 0; i < player.inventory.armorInventory.length; ++i) {
            player.inventory.armorInventory[i] = null;
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/clear");
        }
        sender.sendMessage("/clear <player>");
    }
}

