/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Weather;
import net.minecraft.src.World;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.ClientCommandHandler;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommandHandler;

public class WeatherCommand
extends Command {
    public WeatherCommand() {
        super("weather", "w");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equals("list")) {
            StringBuilder weatherString = new StringBuilder();
            weatherString.append(ChatColor.lightGray + "Available Weathers: " + ChatColor.white);
            weatherString.append("clear");
            for (Weather weather : Weather.weatherList) {
                if (weather == null) continue;
                weatherString.append(", ");
                weatherString.append(weather.languageKey);
            }
            sender.sendMessage(weatherString.toString());
            return true;
        }
        if (sender.isPlayer()) {
            EntityPlayer player = sender.getPlayer();
            if (args[0].equals("next")) {
                player.worldObj.weatherDuration = 0L;
                handler.sendCommandFeedback(sender, "Skipping to next weather");
                return true;
            }
            int dimension = player.dimension;
            Integer duration = null;
            Weather weather = null;
            Float power = null;
            World world = null;
            if (handler instanceof ServerCommandHandler) {
                ServerCommandHandler server = (ServerCommandHandler)handler;
                world = server.minecraftServer.worldMngr[dimension];
            }
            if (handler instanceof ClientCommandHandler) {
                ClientCommandHandler client = (ClientCommandHandler)handler;
                world = client.minecraft.theWorld;
            }
            if (world == null) {
                return false;
            }
            weather = WeatherCommand.getWeather(args[0], world);
            if (weather == null) {
                throw new CommandError("Weather \"" + args[0] + "\" doesnt exist!");
            }
            if (args.length >= 2) {
                duration = Integer.parseInt(args[1]) * 20;
            }
            if (args.length >= 3) {
                power = Float.valueOf(Float.parseFloat(args[2]));
            }
            world.weatherIntensity = 1.0f;
            world.currentWeather = weather;
            world.newWeather = null;
            world.weatherDuration = duration != null ? (long)duration.intValue() : world.getRandomWeatherDuration();
            world.weatherPower = power != null ? power.floatValue() : 1.0f;
            handler.sendCommandFeedback(sender, ChatColor.lightGray + "Changing weather to " + ChatColor.white + weather.getLanguageKey());
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/weather list");
        if (sender.isPlayer()) {
            sender.sendMessage("/weather next");
            sender.sendMessage("/weather <weather> <seconds> <power>");
        }
    }

    public static void setWeather(World world, int weather) {
        world.newWeather = Weather.weatherList[weather];
        world.weatherDuration = Minecraft.DAY_LENGTH_TICKS;
    }

    public static Weather getWeather(String string, World world) {
        try {
            return Weather.getWeather(Integer.parseInt(string));
        }
        catch (Exception exception) {
            try {
                if (string.equalsIgnoreCase("clear")) {
                    Weather w = world.dimension.worldType.defaultWeather;
                    if (w == null) {
                        throw new CommandError("Dimension " + world.dimension.getName() + " does not have a default weather!");
                    }
                    return w;
                }
                return Weather.getWeatherByLanguageKey(string);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

