/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Dimension;
import net.minecraft.src.Item;
import net.minecraft.src.dynamictexture.DynamicTextureAbstractClock;

public class DynamicTextureCalendar
extends DynamicTextureAbstractClock {
    public DynamicTextureCalendar(Minecraft minecraft, int resolution) {
        super(minecraft, "/gui/items.png", "/misc/dialseason.png", Item.toolCalendar.getIconFromDamage(0), resolution);
    }

    @Override
    public double getAngle() {
        if (this.minecraft.theWorld == null) {
            return 0.0;
        }
        if (Dimension.overworld.worldType.seasons == null) {
            return 0.0;
        }
        int yearLength = 0;
        for (int i = 0; i < Dimension.overworld.worldType.seasons.length; ++i) {
            yearLength += Dimension.overworld.worldType.seasons[i].lengthTicks;
        }
        if (yearLength == 0) {
            return 0.0;
        }
        float yearProgress = (float)(this.minecraft.theWorld.getWorldTime() % (long)yearLength) / (float)yearLength;
        return (double)(yearProgress -= 0.25f) * Math.PI * 2.0;
    }
}

