/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.helper.Textures;

public class DynamicTextureCustom
extends DynamicTexture {
    private String textureName;
    private int frameCount;
    private byte[] frames;
    private int elapsedTicks = 0;

    public DynamicTextureCustom(Minecraft mc, String textureName, String animationSource, int textureIndex, int resolution, int width) {
        super(textureIndex, resolution, width);
        this.textureName = textureName;
        BufferedImage image = Textures.readImage(mc.texturePackList.selectedTexturePack.getResourceAsStream(animationSource));
        if (image.getWidth() != resolution) {
            throw new RuntimeException("Animation " + animationSource + "doesn't have the same width as textures in " + textureName + "!");
        }
        if (image.getHeight() % image.getWidth() != 0) {
            throw new RuntimeException("Invalid Height for animation! " + animationSource);
        }
        this.frameCount = image.getHeight() / image.getWidth();
        System.out.println("Frame Count: " + this.frameCount);
        this.frames = new byte[resolution * resolution * 4 * this.frameCount];
        for (int frame = 0; frame < this.frameCount; ++frame) {
            for (int x = 0; x < resolution; ++x) {
                for (int y = 0; y < resolution; ++y) {
                    int c = image.getRGB(x, frame * resolution + y);
                    DynamicTextureCustom.putPixel(this.frames, frame * resolution * resolution + y * resolution + x, c);
                }
            }
        }
    }

    @Override
    public void update() {
        this.elapsedTicks = (this.elapsedTicks + 1) % this.frameCount;
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                DynamicTextureCustom.transferPixel(this.frames, this.elapsedTicks * this.resolution * this.resolution + j * this.resolution + i, this.imageData, j * this.resolution + i);
            }
        }
    }

    @Override
    public String getTextureName() {
        return this.textureName;
    }
}

