/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import net.minecraft.src.helper.ITextField;
import org.lwjgl.input.Keyboard;

public abstract class TextFieldInputHandler {
    public static boolean handleKeyTyped(ITextField textField, int key, char c) {
        if (key == 46 && (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157))) {
            TextFieldInputHandler.copyString(textField.getText());
            return false;
        }
        if (key == 47 && (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157))) {
            String paste = TextFieldInputHandler.getClipboardString();
            if (paste != null) {
                for (int i = 0; i < paste.length(); ++i) {
                    TextFieldInputHandler.addChar(textField, paste.charAt(i));
                }
            }
            return true;
        }
        if (key == 14) {
            String msg = textField.getText();
            if (msg.length() > 0) {
                if (Keyboard.isKeyDown(157) || Keyboard.isKeyDown(29)) {
                    int trimLength = 0;
                    for (int i = 0; i < msg.length(); ++i) {
                        trimLength = msg.charAt(i) != ' ' ? i : trimLength;
                    }
                    int removeIndex = 0;
                    for (int i = 0; i < trimLength; ++i) {
                        removeIndex = msg.charAt(i) == ' ' ? i + 1 : removeIndex;
                    }
                    msg = msg.substring(0, removeIndex);
                } else {
                    msg = msg.substring(0, msg.length() - 1);
                }
                textField.setText(msg);
                return true;
            }
            return false;
        }
        return TextFieldInputHandler.addChar(textField, c);
    }

    public static boolean addChar(ITextField textField, char c) {
        if (textField.isCharacterAllowed(c) && textField.getText().length() < textField.maxLength()) {
            textField.setText(textField.getText() + c);
            return true;
        }
        return false;
    }

    public static void copyString(String string) {
        try {
            StringSelection selection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            System.out.println("Copied String!");
        }
        catch (Exception e) {
            System.err.println("Error copying String: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static String getClipboardString() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

