/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.src.input.InputHandler;
import org.lwjgl.input.Mouse;

public class MouseInput {
    public final Minecraft minecraft;
    public final Controller mouse;
    private Component x;
    private Component y;
    public double deltaX;
    public double deltaY;

    public MouseInput(Minecraft minecraft, Controller mouse) {
        this.minecraft = minecraft;
        this.mouse = mouse;
        this.x = InputHandler.getComponent(mouse, "x");
        this.y = InputHandler.getComponent(mouse, "y");
    }

    public void grabCursor() {
        Mouse.setGrabbed(true);
        Mouse.setCursorPosition(this.minecraft.resolution.width / 2, this.minecraft.resolution.height / 2);
    }

    public void releaseCursor() {
        Mouse.setGrabbed(false);
        Mouse.setCursorPosition(this.minecraft.resolution.width / 2, this.minecraft.resolution.height / 2);
    }

    public void update() {
        if (((Boolean)this.minecraft.gameSettings.rawMouseInput.value).booleanValue() && this.mouse != null) {
            this.mouse.poll();
            this.deltaX = (double)this.x.getPollData() * 0.5;
            this.deltaY = (double)this.y.getPollData() * -0.5;
        } else {
            this.deltaX = Mouse.getDX();
            this.deltaY = Mouse.getDY();
        }
    }
}

