/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import net.minecraft.client.Minecraft;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.helper.ResourceProvider;
import net.minecraft.src.helper.ResourceProviderInternal;
import net.minecraft.src.render.Framebuffer;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Shaderpack;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.Texture;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public abstract class ShadersRenderer
implements IRenderer {
    public final Minecraft minecraft;
    protected final Framebuffer worldFramebuffer = new Framebuffer();
    protected final Texture worldFramebufferTex = new Texture();
    protected final Texture worldFramebufferDepth = new Texture();
    protected final Framebuffer gameFramebuffer = new Framebuffer();
    protected final Texture gameFramebufferTex = new Texture();
    protected final Texture gameFramebufferDepth = new Texture();
    protected final Shaderpack shaderpack = new Shaderpack();
    protected int fbWidth;
    protected int fbHeight;
    public static final ResourceProvider internalShaderFolder = new ResourceProviderInternal("shaders");

    public ShadersRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
        if (!Shaders.shadersCompatible) {
            throw new RuntimeException("Shaders not compatible!");
        }
    }

    @Override
    public void beginRenderGame() {
        if (this.shaderpack.finalShader.isUsable()) {
            this.setupFramebuffer();
            this.gameFramebuffer.bind();
            GL20.glUseProgram(0);
        }
    }

    @Override
    public void endRenderGame() {
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        if (this.shaderpack.finalShader.isUsable()) {
            this.shaderpack.finalShader.bind();
            ARBMultitexture.glActiveTextureARB(33984);
            this.gameFramebufferTex.bind();
            this.shaderpack.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.minecraft, this.shaderpack.finalShader);
            Shaders.drawFullscreenRect();
            GL20.glUseProgram(0);
        }
    }

    @Override
    public void beginRenderWorld() {
        this.setupFramebuffer();
        this.worldFramebuffer.bind();
        Shaders.setUniforms(this.minecraft, this.shaderpack.texturedShader);
        Shaders.setUniforms(this.minecraft, this.shaderpack.basicShader);
        Shaders.setUniforms(this.minecraft, this.shaderpack.terrainShader);
        GL20.glUseProgram(0);
    }

    @Override
    public void endRenderWorld() {
        if (this.shaderpack.finalShader.isUsable()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
        if (this.shaderpack.postShader.isUsable()) {
            this.shaderpack.postShader.bind();
            ARBMultitexture.glActiveTextureARB(33984);
            this.worldFramebufferTex.bind();
            this.shaderpack.postShader.uniformInt("colortex0", 0);
            ARBMultitexture.glActiveTextureARB(33985);
            this.worldFramebufferDepth.bind();
            this.shaderpack.postShader.uniformInt("depthtex0", 1);
            ARBMultitexture.glActiveTextureARB(33984);
            Shaders.setUniforms(this.minecraft, this.shaderpack.postShader);
        } else {
            GL20.glUseProgram(0);
            this.worldFramebufferTex.bind();
        }
        Shaders.drawFullscreenRect();
        GL20.glUseProgram(0);
        GL11.glEnable(3008);
    }

    @Override
    public void beginRenderTerrain() {
    }

    @Override
    public void endRenderTerrain() {
    }

    @Override
    public void beginRenderTextured() {
    }

    @Override
    public void endRenderTextured() {
    }

    @Override
    public void beginRenderBasic() {
    }

    @Override
    public void endRenderBasic() {
    }

    public void setupFramebuffer() {
        if (this.fbWidth != this.minecraft.resolution.width || this.fbHeight != this.minecraft.resolution.height || !this.gameFramebuffer.isGenerated() || !this.worldFramebuffer.isGenerated()) {
            this.worldFramebuffer.generate();
            this.worldFramebufferTex.generate();
            this.worldFramebufferDepth.generate();
            this.gameFramebuffer.generate();
            this.gameFramebufferTex.generate();
            this.gameFramebufferDepth.generate();
            this.fbWidth = this.minecraft.resolution.width;
            this.fbHeight = this.minecraft.resolution.height;
            System.out.println("Setup Framebuffer: " + this.fbWidth + " x " + this.fbHeight);
            Buffer.checkBufferSize(this.fbWidth * this.fbHeight * 4);
            this.worldFramebuffer.bind();
            this.worldFramebufferTex.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6408, this.fbWidth, this.fbHeight, 0, 6408, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.worldFramebufferTex.id(), 0);
            this.worldFramebufferDepth.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6402, this.fbWidth, this.fbHeight, 0, 6402, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.worldFramebufferDepth.id(), 0);
            this.gameFramebuffer.bind();
            this.gameFramebufferTex.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6408, this.fbWidth, this.fbHeight, 0, 6408, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.gameFramebufferTex.id(), 0);
            this.gameFramebufferDepth.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6402, this.fbWidth, this.fbHeight, 0, 6402, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.gameFramebufferDepth.id(), 0);
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
    }

    public abstract ResourceProvider getShader();

    @Override
    public void reload() {
        this.shaderpack.deleteAll();
        ResourceProvider shaderFolder = this.getShader();
        if (shaderFolder != null) {
            try {
                this.shaderpack.postShader.compile(shaderFolder, "post");
                System.out.println("Compiled Post Shader: " + this.shaderpack.postShader.isUsable());
            }
            catch (Exception e) {
                System.err.println("Error compiling post shader: " + e.getClass().getName() + ": " + e.getMessage());
            }
            try {
                this.shaderpack.basicShader.compile(shaderFolder, "basic");
                System.out.println("Compiled Basic Shader: " + this.shaderpack.basicShader.isUsable());
            }
            catch (Exception e) {
                System.err.println("Error compiling basic shader: " + e.getClass().getName() + ": " + e.getMessage());
            }
            try {
                this.shaderpack.texturedShader.compile(shaderFolder, "textured");
                System.out.println("Compiled Textured Shader: " + this.shaderpack.texturedShader.isUsable());
            }
            catch (Exception e) {
                System.err.println("Error compiling textured shader: " + e.getClass().getName() + ": " + e.getMessage());
            }
            try {
                this.shaderpack.terrainShader.compile(shaderFolder, "terrain");
                System.out.println("Compiled Terrain Shader: " + this.shaderpack.terrainShader.isUsable());
            }
            catch (Exception e) {
                System.err.println("Error compiling terrain shader: " + e.getClass().getName() + ": " + e.getMessage());
            }
            try {
                this.shaderpack.finalShader.compile(shaderFolder, "base");
                System.out.println("Compiled Base Shader: " + this.shaderpack.finalShader.isUsable());
            }
            catch (Exception e) {
                System.err.println("Error compiling base shader: " + e.getClass().getName() + ": " + e.getMessage());
            }
        } else {
            this.shaderpack.finalShader.compile(internalShaderFolder, "base");
        }
    }

    @Override
    public boolean clearDepthBeforeRenderHand() {
        return false;
    }

    @Override
    public void disableShader() {
        System.out.println("Disabled Shader");
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        GL20.glUseProgram(0);
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.gameFramebufferDepth.delete();
        this.gameFramebufferTex.delete();
        this.worldFramebuffer.delete();
        this.worldFramebufferDepth.delete();
        this.worldFramebufferTex.delete();
    }

    @Override
    public void create() {
    }
}

