/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import net.minecraft.client.Minecraft;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.render.Framebuffer;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Shaderpack;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.ShadersRenderer;
import net.minecraft.src.render.Texture;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShadersRendererBuiltin
implements IRenderer {
    public static boolean shader = true;
    public final Minecraft minecraft;
    private final Framebuffer gameFramebuffer = new Framebuffer();
    private final Texture colortex = new Texture();
    private final Texture depthtex = new Texture();
    private int fbWidth;
    private int fbHeight;
    public final Shaderpack shaderpack = new Shaderpack();

    public ShadersRendererBuiltin(Minecraft minecraft) {
        this.minecraft = minecraft;
        if (!Shaders.shadersCompatible) {
            throw new RuntimeException("Shaders not compatible!");
        }
    }

    @Override
    public void beginRenderGame() {
        this.setupFramebuffer();
        this.gameFramebuffer.bind();
        GL20.glUseProgram(0);
    }

    @Override
    public void endRenderGame() {
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        if (this.shaderpack.finalShader.isUsable()) {
            this.shaderpack.finalShader.bind();
            ARBMultitexture.glActiveTextureARB(33984);
            this.colortex.bind();
            this.shaderpack.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.minecraft, this.shaderpack.finalShader);
        } else {
            this.colortex.bind();
            GL20.glUseProgram(0);
        }
        Shaders.drawFullscreenRect();
        GL20.glUseProgram(0);
    }

    public void setupFramebuffer() {
        if (this.minecraft.resolution.width != this.fbWidth || this.minecraft.resolution.height != this.fbHeight || !this.gameFramebuffer.isGenerated()) {
            this.gameFramebuffer.generate();
            this.colortex.generate();
            this.depthtex.generate();
            this.fbWidth = this.minecraft.resolution.width;
            this.fbHeight = this.minecraft.resolution.height;
            Buffer.checkBufferSize(this.fbWidth * this.fbHeight * 4);
            this.gameFramebuffer.bind();
            this.colortex.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6408, this.fbWidth, this.fbHeight, 0, 6408, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36064, 3553, this.colortex.id(), 0);
            this.depthtex.bind();
            Buffer.reset();
            GL11.glTexImage2D(3553, 0, 6402, this.fbWidth, this.fbHeight, 0, 6402, 5121, Buffer.buffer);
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
            GL11.glTexParameteri(3553, 10242, 10496);
            GL11.glTexParameteri(3553, 10243, 10496);
            ARBFramebufferObject.glFramebufferTexture2D(36160, 36096, 3553, this.depthtex.id(), 0);
            ARBFramebufferObject.glBindFramebuffer(36160, 0);
        }
    }

    @Override
    public void reload() {
        this.shaderpack.deleteAll();
        this.shaderpack.finalShader.compile(ShadersRenderer.internalShaderFolder, "base");
    }

    @Override
    public void disableShader() {
        ARBFramebufferObject.glBindFramebuffer(36160, 0);
        GL20.glUseProgram(0);
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.colortex.delete();
        this.depthtex.delete();
        this.shaderpack.deleteAll();
    }

    @Override
    public void beginRenderTextured() {
    }

    @Override
    public void endRenderTextured() {
    }

    @Override
    public void beginRenderBasic() {
    }

    @Override
    public void endRenderBasic() {
    }

    @Override
    public void beginRenderWorld() {
    }

    @Override
    public void endRenderWorld() {
    }

    @Override
    public void beginRenderTerrain() {
    }

    @Override
    public void endRenderTerrain() {
    }

    @Override
    public void create() {
    }
}

