/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import net.minecraft.src.render.GLObject;
import org.lwjgl.opengl.GL11;

public class Texture
extends GLObject<Texture> {
    private int id;

    public Texture generate() {
        if (this.isGenerated()) {
            this.delete();
        }
        this.id = GL11.glGenTextures();
        if (!this.isGenerated()) {
            throw new RuntimeException("Texture not created!");
        }
        return this;
    }

    @Override
    public Texture bind() {
        if (!this.isGenerated()) {
            throw new NullPointerException();
        }
        GL11.glBindTexture(3553, this.id);
        return this;
    }

    @Override
    public Texture unbind() {
        GL11.glBindTexture(3553, 0);
        return this;
    }

    public void delete() {
        if (!this.isGenerated()) {
            return;
        }
        GL11.glDeleteTextures(this.id);
        this.id = 0;
    }

    @Override
    public boolean isGenerated() {
        return this.id != 0;
    }

    public int getWidth() {
        return GL11.glGetTexLevelParameteri(3553, 0, 4096);
    }

    public int getHeight() {
        return GL11.glGetTexLevelParameteri(3553, 0, 4097);
    }

    public int id() {
        return this.id;
    }
}

