/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonElement;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;

public class JsonString
implements JsonElement {
    public String value;

    public JsonString(String value) {
        this.value = value;
    }

    public JsonString(StringReader reader) {
        reader.expectAndSkip('\"');
        this.value = "";
        while (true) {
            if (reader.get() == '\"') break;
            if (reader.get() == '\\') {
                reader.next();
                char next = reader.get();
                if (next != 'n' && next != 'N') {
                    throw new InvalidCharacterException(reader);
                }
                this.value = this.value + "\n";
                reader.next();
                continue;
            }
            this.value = this.value + reader.getAndSkip();
        }
        reader.next();
    }

    public boolean equals(JsonString string2) {
        return this.value.equals(string2.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void write(StringWriter writer) {
        writer.write("\"");
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                writer.write("\\n");
                continue;
            }
            if (c == '\t') {
                writer.write("\\t");
                continue;
            }
            writer.write(c);
        }
        writer.write("\"");
    }
}

