/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumSleepStatus;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModelBed;
import net.minecraft.src.World;

public class BlockBed
extends Block {
    public static final int[][] headBlockToFootBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockBed(int i) {
        super(i, Material.wood);
        this.setBounds();
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (!BlockBed.isBlockFootOfBed(meta)) {
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x += headBlockToFootBlockMap[dir][0], y, z += headBlockToFootBlockMap[dir][1]) != this.blockID) {
                return true;
            }
            meta = world.getBlockMetadata(x, y, z);
        }
        if (!world.dimension.worldType.worldProvider.canRespawnHere()) {
            double d = (double)x + 0.5;
            double d1 = (double)y + 0.5;
            double d2 = (double)z + 0.5;
            world.setBlockWithNotify(x, y, z, 0);
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x += headBlockToFootBlockMap[dir][0], y, z += headBlockToFootBlockMap[dir][1]) == this.blockID) {
                world.setBlockWithNotify(x, y, z, 0);
                d = (d + (double)x + 0.5) / 2.0;
                d1 = (d1 + (double)y + 0.5) / 2.0;
                d2 = (d2 + (double)z + 0.5) / 2.0;
            }
            world.newExplosion(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 5.0f, true, false);
            return true;
        }
        if (BlockBed.isBedOccupied(meta)) {
            EntityPlayer player1 = null;
            for (EntityPlayer p : world.players) {
                if (!p.isPlayerSleeping()) continue;
                ChunkCoordinates pos = p.bedChunkCoordinates;
                if (pos.x != x || pos.y != y || pos.z != z) continue;
                player1 = p;
            }
            if (player1 == null) {
                BlockBed.setBedOccupied(world, x, y, z, false);
            } else {
                player.addChatMessage("bed.occupied");
                return true;
            }
        }
        if (player.sleepInBedAt(x, y, z) == EnumSleepStatus.OK) {
            BlockBed.setBedOccupied(world, x, y, z, true);
            return true;
        }
        return true;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 0) {
            return BlockBed.texCoordToIndex(4, 0);
        }
        int k = BlockBed.getDirectionFromMetadata(j);
        int l = ModelBed.bedDirection[k][i];
        if (BlockBed.isBlockFootOfBed(j)) {
            if (l == 2) {
                return BlockBed.texCoordToIndex(8, 9);
            }
            if (l == 5 || l == 4) {
                return BlockBed.texCoordToIndex(7, 9);
            }
            return BlockBed.texCoordToIndex(7, 8);
        }
        if (l == 3) {
            return BlockBed.texCoordToIndex(5, 9);
        }
        if (l == 5 || l == 4) {
            return BlockBed.texCoordToIndex(6, 9);
        }
        return BlockBed.texCoordToIndex(6, 8);
    }

    @Override
    public int getRenderType() {
        return 14;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        this.setBounds();
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        if (BlockBed.isBlockFootOfBed(i1)) {
            if (world.getBlockId(i - headBlockToFootBlockMap[j1][0], j, k - headBlockToFootBlockMap[j1][1]) != this.blockID) {
                world.setBlockWithNotify(i, j, k, 0);
            }
        } else if (world.getBlockId(i + headBlockToFootBlockMap[j1][0], j, k + headBlockToFootBlockMap[j1][1]) != this.blockID) {
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.bed.itemID;
    }

    private void setBounds() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static int getDirectionFromMetadata(int i) {
        return i & 3;
    }

    public static boolean isBlockFootOfBed(int i) {
        return (i & 8) != 0;
    }

    public static boolean isBedOccupied(int i) {
        return (i & 4) != 0;
    }

    public static void setBedOccupied(World world, int i, int j, int k, boolean flag) {
        int l = world.getBlockMetadata(i, j, k);
        l = flag ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = i - headBlockToFootBlockMap[j1][0] * k1 - 1;
            int i2 = k - headBlockToFootBlockMap[j1][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!world.isBlockNormalCube(l2, j - 1, i3) || !world.isAirBlock(l2, j, i3) || !world.isAirBlock(l2, j + 1, i3)) continue;
                    if (l > 0) {
                        --l;
                        continue;
                    }
                    return new ChunkCoordinates(l2, j, i3);
                }
            }
        }
        return null;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

