/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class BlockCactus
extends Block {
    public BlockCactus(int i) {
        super(i, Material.cactus);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isAirBlock(i, j + 1, k)) {
            int l = 1;
            while (world.getBlockId(i, j - l, k) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockMetadata(i, j, k);
                if (i1 == 15) {
                    world.setBlockWithNotify(i, j + 1, k, this.blockID);
                    world.setBlockMetadataWithNotify(i, j, k, 0);
                } else {
                    world.setBlockMetadataWithNotify(i, j, k, i1 + 1);
                }
            }
        }
    }

    public void growCactusOnTop(World world, int x, int y, int z) {
        int l = 1;
        while (world.getBlockId(x, y + l, z) == this.blockID) {
            ++l;
        }
        if (world.isAirBlock(x, y + l, z)) {
            world.setBlockWithNotify(x, y + l, z, this.blockID);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (float)(j + 1) - f, (float)(k + 1) - f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, j + 1, (float)(k + 1) - f);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 13;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (!super.canPlaceBlockAt(world, i, j, k)) {
            return false;
        }
        return this.canBlockStay(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        if (world.getBlockMaterial(i - 1, j, k).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(i + 1, j, k).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(i, j, k - 1).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(i, j, k + 1).isSolid()) {
            return false;
        }
        int l = world.getBlockId(i, j - 1, k);
        return l == Block.cactus.blockID || l == Block.sand.blockID;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (entity instanceof EntityLiving) {
            entity.attackEntityFrom(null, 1, DamageType.COMBAT);
        }
    }
}

