/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryLargeChest;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.World;

public class BlockChest
extends BlockContainer {
    private Random random = new Random();

    public BlockChest(int i) {
        super(i, Material.wood);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        if (side == 1) {
            return BlockChest.texCoordToIndex(9, 1);
        }
        if (side == 0) {
            return BlockChest.texCoordToIndex(9, 1);
        }
        int negZ = iblockaccess.getBlockId(x, y, z - 1);
        int posZ = iblockaccess.getBlockId(x, y, z + 1);
        int negX = iblockaccess.getBlockId(x - 1, y, z);
        int posX = iblockaccess.getBlockId(x + 1, y, z);
        if (this.isChest(negZ) || this.isChest(posZ)) {
            if (side == 2 || side == 3) {
                return BlockChest.texCoordToIndex(10, 1);
            }
            int i2 = 0;
            if (this.isChest(negZ)) {
                i2 = -1;
            }
            int k2 = iblockaccess.getBlockId(x - 1, y, !this.isChest(negZ) ? z + 1 : z - 1);
            int i3 = iblockaccess.getBlockId(x + 1, y, !this.isChest(negZ) ? z + 1 : z - 1);
            if (side == 4) {
                i2 = -1 - i2;
            }
            int byte1 = 5;
            if ((Block.opaqueCubeLookup[negX] || Block.opaqueCubeLookup[k2]) && !Block.opaqueCubeLookup[posX] && !Block.opaqueCubeLookup[i3]) {
                byte1 = 5;
            }
            if ((Block.opaqueCubeLookup[posX] || Block.opaqueCubeLookup[i3]) && !Block.opaqueCubeLookup[negX] && !Block.opaqueCubeLookup[k2]) {
                byte1 = 4;
            }
            return (side != byte1 ? BlockChest.texCoordToIndex(10, 3) : BlockChest.texCoordToIndex(10, 2)) + i2;
        }
        if (this.isChest(negX) || this.isChest(posX)) {
            if (side == 4 || side == 5) {
                return BlockChest.texCoordToIndex(10, 1);
            }
            int j2 = 0;
            if (this.isChest(negX)) {
                j2 = -1;
            }
            int l2 = iblockaccess.getBlockId(!this.isChest(negX) ? x + 1 : x - 1, y, z - 1);
            int j3 = iblockaccess.getBlockId(!this.isChest(negX) ? x + 1 : x - 1, y, z + 1);
            if (side == 3) {
                j2 = -1 - j2;
            }
            int byte2 = 3;
            if ((Block.opaqueCubeLookup[negZ] || Block.opaqueCubeLookup[l2]) && !Block.opaqueCubeLookup[posZ] && !Block.opaqueCubeLookup[j3]) {
                byte2 = 3;
            }
            if ((Block.opaqueCubeLookup[posZ] || Block.opaqueCubeLookup[j3]) && !Block.opaqueCubeLookup[negZ] && !Block.opaqueCubeLookup[l2]) {
                byte2 = 2;
            }
            return (side != byte2 ? BlockChest.texCoordToIndex(10, 3) : BlockChest.texCoordToIndex(10, 2)) + j2;
        }
        int byte0 = 3;
        if (Block.opaqueCubeLookup[negZ] && !Block.opaqueCubeLookup[posZ]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[posZ] && !Block.opaqueCubeLookup[negZ]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[negX] && !Block.opaqueCubeLookup[posX]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[posX] && !Block.opaqueCubeLookup[negX]) {
            byte0 = 4;
        }
        return side != byte0 ? BlockChest.texCoordToIndex(10, 1) : BlockChest.texCoordToIndex(11, 1);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1 || i == 0) {
            return BlockChest.texCoordToIndex(9, 1);
        }
        if (i == 4) {
            return BlockChest.texCoordToIndex(11, 1);
        }
        return BlockChest.texCoordToIndex(10, 1);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = 0;
        if (this.isChest(world.getBlockId(i - 1, j, k))) {
            ++l;
        }
        if (this.isChest(world.getBlockId(i + 1, j, k))) {
            ++l;
        }
        if (this.isChest(world.getBlockId(i, j, k - 1))) {
            ++l;
        }
        if (this.isChest(world.getBlockId(i, j, k + 1))) {
            ++l;
        }
        if (l > 1) {
            return false;
        }
        if (this.isThereANeighborChest(world, i - 1, j, k)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i + 1, j, k)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i, j, k - 1)) {
            return false;
        }
        return !this.isThereANeighborChest(world, i, j, k + 1);
    }

    private boolean isThereANeighborChest(World world, int i, int j, int k) {
        if (!this.isChest(world.getBlockId(i, j, k))) {
            return false;
        }
        if (this.isChest(world.getBlockId(i - 1, j, k))) {
            return true;
        }
        if (this.isChest(world.getBlockId(i + 1, j, k))) {
            return true;
        }
        if (this.isChest(world.getBlockId(i, j, k - 1))) {
            return true;
        }
        return this.isChest(world.getBlockId(i, j, k + 1));
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        for (int l = 0; l < tileentitychest.getSizeInventory(); ++l) {
            ItemStack itemstack = tileentitychest.getStackInSlot(l);
            if (itemstack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int i1 = this.random.nextInt(21) + 10;
                if (i1 > itemstack.stackSize) {
                    i1 = itemstack.stackSize;
                }
                itemstack.stackSize -= i1;
                EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                float f3 = 0.05f;
                entityitem.motionX = (float)this.random.nextGaussian() * f3;
                entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                world.entityJoinedWorld(entityitem);
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    protected boolean isChest(int id) {
        return Block.blocksList[id] instanceof BlockChest;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        IInventory obj = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        if (BlockChest.isChestBlocked(world, i, j, k)) {
            return true;
        }
        if (this.isChest(world.getBlockId(i - 1, j, k)) && BlockChest.isChestBlocked(world, i - 1, j, k)) {
            return true;
        }
        if (this.isChest(world.getBlockId(i + 1, j, k)) && BlockChest.isChestBlocked(world, i + 1, j, k)) {
            return true;
        }
        if (this.isChest(world.getBlockId(i, j, k - 1)) && BlockChest.isChestBlocked(world, i, j, k - 1)) {
            return true;
        }
        if (this.isChest(world.getBlockId(i, j, k + 1)) && BlockChest.isChestBlocked(world, i, j, k + 1)) {
            return true;
        }
        if (this.isChest(world.getBlockId(i - 1, j, k))) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i - 1, j, k), obj);
        }
        if (this.isChest(world.getBlockId(i + 1, j, k))) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i + 1, j, k));
        }
        if (this.isChest(world.getBlockId(i, j, k - 1))) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i, j, k - 1), obj);
        }
        if (this.isChest(world.getBlockId(i, j, k + 1))) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i, j, k + 1));
        }
        if (!world.isMultiplayerAndNotHost) {
            entityplayer.displayGUIChest(obj);
        }
        return true;
    }

    public static boolean isChestBlocked(World world, int x, int y, int z) {
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

