/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFence
extends Block {
    public BlockFence(int i) {
        super(i, Material.wood);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        boolean connectXPos = this.canConnectTo(world, i + 1, j, k);
        boolean connectXNeg = this.canConnectTo(world, i - 1, j, k);
        boolean connectZPos = this.canConnectTo(world, i, j, k + 1);
        boolean connectZNeg = this.canConnectTo(world, i, j, k - 1);
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + (connectXNeg ? 0.0f : 0.375f), j, (float)k + (connectZNeg ? 0.0f : 0.375f), (float)(i + 1) - (connectXPos ? 0.0f : 0.375f), (float)j + 1.5f, (float)(k + 1) - (connectZPos ? 0.0f : 0.375f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.getCollisionBoundingBoxFromPool(world, i, j, k).expand(0.0, -0.25, 0.0).offset(0.0, -0.25, 0.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        AxisAlignedBB aabb = this.getCollisionBoundingBoxFromPool(world, i, j, k);
        this.minX = aabb.minX - (double)i;
        this.minY = aabb.minY - (double)j;
        this.minZ = aabb.minZ - (double)k;
        this.maxX = aabb.maxX - (double)i;
        this.maxY = aabb.maxY - (double)j - 0.5;
        this.maxZ = aabb.maxZ - (double)k;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 11;
    }

    public boolean canConnectTo(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockId(i, j, k);
        return Block.blocksList[l] != null && Block.blocksList[l].canFenceConnectTo;
    }
}

