/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.World;

public class BlockFurnace
extends BlockContainerRotatable {
    protected Random furnaceRand = new Random();
    protected final boolean isActive;
    protected static boolean keepFurnaceInventory = false;

    public BlockFurnace(int i, boolean flag) {
        super(i, Material.rock);
        this.isActive = flag;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.furnaceStoneIdle.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.isActive) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        float f = (float)i + 0.5f;
        float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)k + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.spawnParticle("smoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 5) {
            world.spawnParticle("smoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i, j, k);
            entityplayer.displayGUIFurnace(tileentityfurnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean lit, World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        TileEntity tileentity = world.getBlockTileEntity(x, y, z);
        if (tileentity == null) {
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockWithNotify(x, y, z, Block.furnaceStoneActive.blockID);
        } else {
            world.setBlockWithNotify(x, y, z, Block.furnaceStoneIdle.blockID);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(x, y, z, l);
        tileentity.validate();
        world.setBlockTileEntity(x, y, z, tileentity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!keepFurnaceInventory) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i, j, k);
            for (int l = 0; l < tileentityfurnace.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.furnaceRand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.furnaceRand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }
}

