/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockGrass
extends Block {
    public BlockGrass(int i, Material material) {
        super(i, material);
        this.setTickOnLoad(true);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getBlockMaterial(i, j + 1, k);
        if (!(material != Material.snow && material != Material.builtSnow || l != 4 && l != 5 && l != 2 && l != 3)) {
            return BlockGrass.texCoordToIndex(4, 4);
        }
        return super.getBlockTexture(iblockaccess, i, j, k, l);
    }

    public int func_35274_i() {
        double d = 0.5;
        double d1 = 0.5;
        return ColorizerGrass.getGrassColor(d, d1);
    }

    @Override
    public int getRenderColor(int i) {
        return this.func_35274_i();
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        Season season;
        double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
        double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null && (season = world.getCurrentSeason()) != null) {
            float progress = (float)world.dayInSeason / (float)(season.lengthTicks / Minecraft.DAY_LENGTH_TICKS);
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getNextSeason() : world.getLastSeason(), Math.abs(progress - 0.5f));
        }
        return baseGrassColor;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getBlockLightValue(i, j + 1, k) < 4 && Block.lightOpacity[world.getBlockId(i, j + 1, k)] > 2) {
            if (random.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        } else if (world.getBlockLightValue(i, j + 1, k) >= 9) {
            int l = i + random.nextInt(3) - 1;
            int i1 = j + random.nextInt(5) - 3;
            int j1 = k + random.nextInt(3) - 1;
            int k1 = world.getBlockId(l, i1 + 1, j1);
            if (world.getBlockId(l, i1, j1) == Block.dirt.blockID && world.getBlockLightValue(l, i1 + 1, j1) >= 4 && Block.lightOpacity[k1] <= 2 && world.currentSeason != Season.surfaceWinter) {
                world.setBlockWithNotify(l, i1, j1, this.blockID);
            }
            if (world.getBlockId(i, j + 1, k) == 0 && world.currentSeason != null && world.currentSeason.growFlowers && random.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r = random.nextInt(400);
                idToSpawn = r < 26 ? Block.flowerRed.blockID : (r < 41 ? Block.flowerYellow.blockID : (random.nextInt(8) == 0 ? Block.tallgrassFern.blockID : Block.tallgrass.blockID));
                world.setBlockWithNotify(i, j + 1, k, idToSpawn);
            }
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.dirt.idDropped(0, random);
    }
}

