/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockLamp
extends Block {
    boolean isActive;

    public BlockLamp(int i, boolean isActivated) {
        super(i, Material.rock);
        this.isActive = isActivated;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        return this.getRenderColor(meta);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.atlasIndices[l];
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return BlockLamp.texCoordToIndex(5, 12);
    }

    @Override
    public int getRenderColor(int i) {
        switch (i) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 16741412;
            }
            case 2: {
                return 13795801;
            }
            case 3: {
                return 11058687;
            }
            case 4: {
                return 16772393;
            }
            case 5: {
                return 3014426;
            }
            case 6: {
                return 16728734;
            }
            case 7: {
                return 0x7D7D7D;
            }
            case 8: {
                return 0xBBC9C9;
            }
            case 9: {
                return 5097983;
            }
            case 10: {
                return 9707004;
            }
            case 11: {
                return 660223;
            }
            case 12: {
                return 0x663300;
            }
            case 13: {
                return 6861568;
            }
            case 14: {
                return 16717583;
            }
            case 15: {
                return 0x363636;
            }
        }
        return 0xFFFFFF;
    }

    public static int func_21034_c(int i) {
        return ~i & 0xF;
    }

    public static int getMetadataForColour(int i) {
        return ~i & 0xF;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        boolean isPoweredByBlock;
        boolean bl = isPoweredByBlock = world.isBlockGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j, k);
        if (this.isActive) {
            if (!isPoweredByBlock) {
                world.setBlockAndMetadataWithNotify(i, j, k, Block.lampIdle.blockID, world.getBlockMetadata(i, j, k));
            }
        } else if (isPoweredByBlock) {
            world.setBlockAndMetadataWithNotify(i, j, k, Block.lampActive.blockID, world.getBlockMetadata(i, j, k));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.lampIdle.blockID;
    }

    @Override
    protected int damageDropped(int i) {
        return i;
    }
}

