/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLog;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLeavesBase
extends Block {
    int[] adjacentTreeBlocks;
    protected static boolean fancyGraphics;

    public BlockLeavesBase(int i, Material material, boolean flag) {
        super(i, material);
        fancyGraphics = flag;
        this.setTickOnLoad(true);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return !fancyGraphics ? this.atlasIndices[i] + 1 : this.atlasIndices[i];
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getCurrentSeason() == Season.surfaceWinter && world.rand.nextInt(5) > 0) {
            return;
        }
        int i1 = this.quantityDropped(l, world.rand);
        if (world.getCurrentSeason() == Season.surfaceSpring && world.rand.nextInt(10) == 0) {
            ++i1;
        }
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.rand.nextFloat() > f || (k1 = this.idDropped(l, world.rand)) <= 0) continue;
            world.dropItem(i, j, k, new ItemStack(k1, 1, this.damageDropped(l)));
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int i1 = iblockaccess.getBlockId(i, j, k);
        if (!fancyGraphics && i1 == this.blockID) {
            return false;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        int l = 1;
        int i1 = l + 1;
        if (world.checkChunksExist(i - i1, j - i1, k - i1, i + i1, j + i1, k + i1)) {
            for (int j1 = -l; j1 <= l; ++j1) {
                for (int k1 = -l; k1 <= l; ++k1) {
                    for (int l1 = -l; l1 <= l; ++l1) {
                        int i2 = world.getBlockId(i + j1, j + k1, k + l1);
                        if (!(Block.blocksList[i2] instanceof BlockLeavesBase)) continue;
                        int j2 = world.getBlockMetadata(i + j1, j + k1, k + l1);
                        world.setBlockMetadata(i + j1, j + k1, k + l1, j2 | 8);
                    }
                }
            }
        }
    }

    public static void setGraphicsLevel(boolean flag) {
        fancyGraphics = flag;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) != 0) {
            int j2;
            int byte0 = 4;
            int offset = byte0 + 1;
            int length = 32;
            int xSpan = length * length;
            int halfLength = length / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[length * length * length];
            }
            if (world.checkChunksExist(x - offset, y - offset, z - offset, x + offset, y + offset, z + offset)) {
                for (int xOffset = -byte0; xOffset <= byte0; ++xOffset) {
                    for (int yOffset = -byte0; yOffset <= byte0; ++yOffset) {
                        for (int zOffset = -byte0; zOffset <= byte0; ++zOffset) {
                            int k3 = world.getBlockId(x + xOffset, y + yOffset, z + zOffset);
                            this.adjacentTreeBlocks[(xOffset + halfLength) * xSpan + (yOffset + halfLength) * length + (zOffset + halfLength)] = Block.blocksList[k3] instanceof BlockLog ? 0 : (Block.blocksList[k3] instanceof BlockLeavesBase ? -2 : -1);
                        }
                    }
                }
                for (int i2 = 1; i2 <= 4; ++i2) {
                    for (int l2 = -byte0; l2 <= byte0; ++l2) {
                        for (int j3 = -byte0; j3 <= byte0; ++j3) {
                            for (int l3 = -byte0; l3 <= byte0; ++l3) {
                                if (this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] != i2 - 1) continue;
                                if (this.adjacentTreeBlocks[(l2 + halfLength - 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l2 + halfLength - 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l2 + halfLength + 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l2 + halfLength + 1) * xSpan + (j3 + halfLength) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength - 1) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength - 1) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength + 1) * length + (l3 + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength + 1) * length + (l3 + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength - 1)] == -2) {
                                    this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength - 1)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength + 1)] != -2) continue;
                                this.adjacentTreeBlocks[(l2 + halfLength) * xSpan + (j3 + halfLength) * length + (l3 + halfLength + 1)] = i2;
                            }
                        }
                    }
                }
            }
            if ((j2 = this.adjacentTreeBlocks[halfLength * xSpan + halfLength * length + halfLength]) >= 0) {
                world.setBlockMetadata(x, y, z, l & 0xFFFFFFF7);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int i, int j, int k) {
        this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
        world.setBlockWithNotify(i, j, k, 0);
    }
}

