/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BlockLeavesCherry;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLeavesCherryFlowering
extends BlockLeavesCherry {
    public BlockLeavesCherryFlowering(int i) {
        super(i);
    }

    @Override
    public int getRenderType() {
        return 23;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        if (metadata != 1) {
            return 0;
        }
        return random.nextInt(2) + 1;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.cherry.itemID;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.getBlockMetadata(i, j, k) == 1) {
            Random rand = new Random();
            world.playSoundAtEntity(entityplayer, "random.pop", 0.2f, 0.5f);
            if (!world.isMultiplayerAndNotHost) {
                this.dropBlockAsItem(world, i, j, k, 1);
            }
            world.setBlockMetadataWithNotify(i, j, k, 0);
            world.scheduleBlockUpdate(i, j, k, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
            return true;
        }
        return super.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        super.updateTick(world, x, y, z, random);
        int metadata = world.getBlockMetadata(x, y, z);
        if (world.getCurrentSeason() == Season.surfaceSpring) {
            if (random.nextInt(20) == 0 && metadata == 0) {
                world.setBlockMetadataWithNotify(x, y, z, 1);
                world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
            }
        } else if ((metadata & 1) == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.blockID, this.tickRate());
        }
    }
}

