/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerLeaves;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLeavesOak
extends BlockLeavesBase {
    public BlockLeavesOak(int i) {
        super(i, Material.leaves, false);
    }

    @Override
    public int getRenderColor(int i) {
        return ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int baseFoliageColor = ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
        if (world != null) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
            Season season = world.getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonProgress();
                baseFoliageColor = ColorizerFoliage.getSeasonalColor(season, progress, localTemperature, localHumidity, ColorProperties.oak, true);
            }
        }
        return baseFoliageColor;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
        if (random.nextInt(128) == 0 && world.getCurrentSeason() != null && world.getCurrentSeason().hasFallingLeaves) {
            int id;
            for (int q = -1; q > -16 && (id = world.getBlockId(i, j + q, k)) == 0; --q) {
                if (Block.layerLeavesOak.canPlaceBlockAt(world, i, j + q, k) && Block.blocksList[world.getBlockId((int)i, (int)(j + q - 1), (int)k)].blockMaterial.getIsSolid()) {
                    world.setBlockWithNotify(i, j + q, k, Block.layerLeavesOak.blockID);
                    break;
                }
                if (world.getBlockId(i, j + q, k) != Block.layerLeavesOak.blockID) continue;
                ((BlockLayerLeaves)Block.layerLeavesOak).accumulate(world, i, j + q, k);
                break;
            }
        }
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return random.nextInt(20) != 0 ? 0 : 1;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.saplingOak.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, l & 3));
        } else {
            super.harvestBlock(world, entityplayer, i, j, k, l);
        }
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (world.getCurrentSeason() != null && world.getCurrentSeason().hasFallingLeaves && random.nextInt(40) == 0) {
            world.spawnParticle("fallingleaf", i, (float)j - 0.1f, k, 0.0, 0.0, 0.0);
        }
    }
}

