/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLeavesPine
extends BlockLeavesBase {
    public BlockLeavesPine(int i) {
        super(i, Material.leaves, false);
    }

    @Override
    public int getRenderColor(int i) {
        return ColorProperties.fRGB2iRGB(ColorProperties.pine.inventoryR, ColorProperties.pine.inventoryG, ColorProperties.pine.inventoryB);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int baseFoliageColor = ColorProperties.fRGB2iRGB(ColorProperties.pine.inventoryR, ColorProperties.pine.inventoryG, ColorProperties.pine.inventoryB);
        if (world != null) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
            Season season = world.getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonProgress();
                baseFoliageColor = ColorizerFoliage.getSeasonalColor(season, progress, localTemperature, localHumidity, ColorProperties.pine);
            }
        }
        return baseFoliageColor;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return random.nextInt(20) != 0 ? 0 : 1;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int i1 = this.quantityDropped(l, world.rand);
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.rand.nextFloat() > f || (k1 = this.idDropped(l, world.rand)) <= 0) continue;
            world.dropItem(i, j, k, new ItemStack(k1, 1, this.damageDropped(l)));
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.saplingPine.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, l & 3));
        } else {
            super.harvestBlock(world, entityplayer, i, j, k, l);
        }
    }
}

