/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockMobSpawner
extends BlockContainer {
    public BlockMobSpawner(int i) {
        super(i, Material.rock);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityMobSpawner();
    }

    @Override
    public int idDropped(int i, Random random) {
        return 0;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        TileEntityMobSpawner tileEntity = (TileEntityMobSpawner)world.getBlockTileEntity(x, y, z);
        tileEntity.setMobID("none");
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.getBlockTileEntity(i, j, k);
            int amountToDrop = world.rand.nextInt(10) + 10;
            for (int l = 0; l < amountToDrop; ++l) {
                ItemStack itemstack;
                String mobInSpawner = tileEntityMobSpawner.getMobID();
                if (mobInSpawner == null) continue;
                switch (mobInSpawner) {
                    case "Zombie": {
                        itemstack = new ItemStack(Item.cloth);
                        break;
                    }
                    case "Skeleton": {
                        if (world.rand.nextInt(2) == 0) {
                            itemstack = new ItemStack(Item.bone);
                            break;
                        }
                        itemstack = new ItemStack(Item.ammoArrow);
                        break;
                    }
                    case "ArmouredZombie": {
                        itemstack = new ItemStack(Item.chainlink);
                        break;
                    }
                    case "Spider": {
                        itemstack = new ItemStack(Item.string);
                        break;
                    }
                    default: {
                        itemstack = null;
                    }
                }
                if (itemstack == null) continue;
                float f = world.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)world.rand.nextGaussian() * f3;
                    entityitem.motionY = (float)world.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)world.rand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }
}

