/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.World;

public class BlockMushroom
extends BlockFlower {
    public BlockMushroom(int i) {
        super(i);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int l;
        if (random.nextInt(100) == 0 && world.isAirBlock(l = i + random.nextInt(3) - 1, i1 = j + random.nextInt(2) - random.nextInt(2), j1 = k + random.nextInt(3) - 1) && this.canBlockStay(world, l, i1, j1)) {
            i += random.nextInt(3) - 1;
            k += random.nextInt(3) - 1;
            if (world.isAirBlock(l, i1, j1) && this.canBlockStay(world, l, i1, j1)) {
                world.setBlockWithNotify(l, i1, j1, this.blockID);
            }
        }
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return Block.opaqueCubeLookup[i];
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        if (j < 0 || j >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        return world.getFullBlockLightValue(i, j, k) < 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(i, j - 1, k));
    }
}

