/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityNote;
import net.minecraft.src.World;

public class BlockNote
extends BlockContainer {
    public BlockNote(int i) {
        super(i, Material.wood);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.blocksList[l].canProvidePower()) {
            boolean flag = world.isBlockGettingPowered(i, j, k);
            TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i, j, k);
            if (tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(world, i, j, k);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i, j, k);
        tileentitynote.changePitch();
        tileentitynote.triggerNote(world, i, j, k);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(i, j, k);
        tileentitynote.triggerNote(world, i, j, k);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityNote();
    }

    @Override
    public void playBlock(World world, int i, int j, int k, int l, int i1) {
        float f = (float)Math.pow(2.0, (double)(i1 - 12) / 12.0);
        String s = "harp";
        if (l == 1) {
            s = "bd";
        }
        if (l == 2) {
            s = "snare";
        }
        if (l == 3) {
            s = "hat";
        }
        if (l == 4) {
            s = "bassattack";
        }
        world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "note." + s, 3.0f, f);
        world.spawnParticle("note", (double)i + 0.5, (double)j + 1.2, (double)k + 0.5, (double)i1 / 24.0, 0.0, 0.0);
    }
}

