/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockOreRedstone
extends Block {
    private boolean illuminated;

    public BlockOreRedstone(int i, boolean flag) {
        super(i, Material.rock);
        if (flag) {
            this.setTickOnLoad(true);
        }
        this.illuminated = flag;
    }

    @Override
    public int getBlockOverbright(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this.illuminated) {
            return Block.texCoordToIndex(4, 16);
        }
        return -1;
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.lightRedstone(world, i, j, k);
        super.onBlockClicked(world, i, j, k, entityplayer);
    }

    @Override
    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        this.lightRedstone(world, i, j, k);
        super.onEntityWalking(world, i, j, k, entity);
    }

    private void lightRedstone(World world, int i, int j, int k) {
        this.func_319_i(world, i, j, k);
        if (!this.illuminated) {
            world.setBlockWithNotify(i, j, k, this.blockID + 10);
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.illuminated) {
            world.setBlockWithNotify(i, j, k, this.blockID - 10);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.dustRedstone.itemID;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 4 + random.nextInt(2);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (this.illuminated) {
            this.func_319_i(world, i, j, k);
        }
    }

    @Override
    public void dropBlockWhenCrushed(World world, int i, int j, int k, int l) {
        if (this.illuminated) {
            world.dropItem(i, j, k, new ItemStack(this.blockID - 10, 1, l));
        } else {
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, l));
        }
    }

    private void func_319_i(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockOpaqueCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockOpaqueCube(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.isBlockOpaqueCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockOpaqueCube(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.isBlockOpaqueCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockOpaqueCube(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }
}

