/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockPistonMoving;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.PistonModel;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockPistonBase
extends Block {
    private boolean isSticky;
    private boolean field_31048_b;

    public BlockPistonBase(int i, boolean flag) {
        super(i, Material.piston);
        this.isSticky = flag;
        this.setStepSound(soundStoneFootstep);
        this.setHardness(0.5f);
    }

    public int func_31040_i() {
        return !this.isSticky ? BlockPistonBase.texCoordToIndex(11, 6) : BlockPistonBase.texCoordToIndex(10, 6);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        int orientation = BlockPistonBase.getOrientation(j);
        if (orientation > 5) {
            return this.atlasIndices[0];
        }
        if (i == orientation) {
            if (BlockPistonBase.isPowered(j) || this.minX > 0.0 || this.minY > 0.0 || this.minZ > 0.0 || this.maxX < 1.0 || this.maxY < 1.0 || this.maxZ < 1.0) {
                return BlockPistonBase.texCoordToIndex(14, 6);
            }
            return this.atlasIndices[0];
        }
        return i != PistonModel.field_31057_a[orientation] ? BlockPistonBase.texCoordToIndex(12, 6) : BlockPistonBase.texCoordToIndex(13, 6);
    }

    @Override
    public int getRenderType() {
        return 16;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        world.setBlockMetadataWithNotify(x, y, z, player.getPlacementDirection(side).meta());
        if (!world.isMultiplayerAndNotHost) {
            this.func_31043_h(world, x, y, z);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && !this.field_31048_b) {
            this.func_31043_h(world, i, j, k);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.isMultiplayerAndNotHost && world.getBlockTileEntity(i, j, k) == null) {
            this.func_31043_h(world, i, j, k);
        }
    }

    private void func_31043_h(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        int meta = BlockPistonBase.getOrientation(l);
        boolean flag = this.func_31041_f(world, x, y, z, meta);
        if (l == 7) {
            return;
        }
        if (flag && !BlockPistonBase.isPowered(l)) {
            if (BlockPistonBase.func_31045_h(world, x, y, z, meta)) {
                world.setBlockMetadata(x, y, z, meta | 8);
                world.playNoteAt(x, y, z, 0, meta);
            }
        } else if (!flag && BlockPistonBase.isPowered(l)) {
            world.setBlockMetadata(x, y, z, meta);
            world.playNoteAt(x, y, z, 1, meta);
        }
    }

    private boolean func_31041_f(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }

    @Override
    public void playBlock(World world, int x, int y, int z, int instrument, int pitch) {
        this.field_31048_b = true;
        int meta = pitch;
        if (instrument == 0) {
            if (this.tryExtend(world, x, y, z, meta)) {
                world.setBlockMetadataWithNotify(x, y, z, meta | 8);
                world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.rand.nextFloat() * 0.25f + 0.6f);
            }
        } else if (instrument == 1) {
            TileEntity tileentity = world.getBlockTileEntity(x + PistonModel.xOffset[meta], y + PistonModel.yOffset[meta], z + PistonModel.zOffset[meta]);
            if (tileentity != null && tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).clearPistonTileEntity();
            }
            world.setBlockAndMetadata(x, y, z, Block.pistonMoving.blockID, meta);
            world.setBlockTileEntity(x, y, z, BlockPistonMoving.func_31036_a(this.blockID, meta, meta, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                int x1 = x + PistonModel.xOffset[meta] * 2;
                int y1 = y + PistonModel.yOffset[meta] * 2;
                int z1 = z + PistonModel.zOffset[meta] * 2;
                int id1 = world.getBlockId(x1, y1, z1);
                int meta1 = world.getBlockMetadata(x1, y1, z1);
                boolean flag = false;
                if (id1 == Block.pistonMoving.blockID && (tileentity1 = world.getBlockTileEntity(x1, y1, z1)) != null && tileentity1 instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).func_31009_d() == meta && tileentitypiston.func_31015_b()) {
                    tileentitypiston.clearPistonTileEntity();
                    id1 = tileentitypiston.getStoredBlockID();
                    meta1 = tileentitypiston.getBlockMetadata();
                    flag = true;
                }
                if (!flag && id1 > 0 && BlockPistonBase.canPushBlock(id1, world, x1, y1, z1, false) && (Block.blocksList[id1].getMobilityFlag() == 0 || id1 == Block.pistonBase.blockID || id1 == Block.pistonBaseSticky.blockID)) {
                    this.field_31048_b = false;
                    world.setBlockWithNotify(x1, y1, z1, 0);
                    this.field_31048_b = true;
                    world.setBlockAndMetadata(x += PistonModel.xOffset[meta], y += PistonModel.yOffset[meta], z += PistonModel.zOffset[meta], Block.pistonMoving.blockID, meta1);
                    world.setBlockTileEntity(x, y, z, BlockPistonMoving.func_31036_a(id1, meta1, meta, false, false));
                } else if (!flag) {
                    this.field_31048_b = false;
                    world.setBlockWithNotify(x + PistonModel.xOffset[meta], y + PistonModel.yOffset[meta], z + PistonModel.zOffset[meta], 0);
                    this.field_31048_b = true;
                }
            } else {
                this.field_31048_b = false;
                world.setBlockWithNotify(x + PistonModel.xOffset[meta], y + PistonModel.yOffset[meta], z + PistonModel.zOffset[meta], 0);
                this.field_31048_b = true;
            }
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
        }
        this.field_31048_b = false;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (BlockPistonBase.isPowered(l)) {
            switch (BlockPistonBase.getOrientation(l)) {
                case 0: {
                    this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int getOrientation(int i) {
        return i & 7;
    }

    public static boolean isPowered(int i) {
        return (i & 8) != 0;
    }

    private static boolean canPushBlock(int i, World world, int j, int k, int l, boolean flag) {
        TileEntity tileentity;
        if (i == Block.obsidian.blockID) {
            return false;
        }
        if (i == Block.pistonBase.blockID || i == Block.pistonBaseSticky.blockID) {
            if (BlockPistonBase.isPowered(world.getBlockMetadata(j, k, l))) {
                return false;
            }
        } else {
            if (Block.blocksList[i].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[i].getMobilityFlag() == 2) {
                return false;
            }
            if (Block.blocksList[i].getImmovable()) {
                return false;
            }
            if (!flag && Block.blocksList[i].getMobilityFlag() == 1) {
                return false;
            }
        }
        return (tileentity = world.getBlockTileEntity(j, k, l)) == null;
    }

    private static boolean func_31045_h(World world, int x, int y, int z, int meta) {
        int x1 = x + PistonModel.xOffset[meta % 6];
        int y1 = y + PistonModel.yOffset[meta % 6];
        int z1 = z + PistonModel.zOffset[meta % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (y1 <= 0 || y1 >= Minecraft.WORLD_HEIGHT_BLOCKS - 1) {
                return false;
            }
            int i2 = world.getBlockId(x1, y1, z1);
            if (i2 == 0) break;
            if (!BlockPistonBase.canPushBlock(i2, world, x1, y1, z1, true)) {
                if (l1 == 1 && (i2 == Block.obsidian.blockID || i2 == Block.bedrock.blockID)) {
                    int x2 = x + PistonModel.xOffset[meta % 6];
                    int y2 = y + PistonModel.yOffset[meta % 6];
                    int z2 = z + PistonModel.zOffset[meta % 6];
                    world.playSoundEffectForPlayer(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
                    Block.blocksList[world.getBlockId(x2, y2, z2)].dropBlockWhenCrushed(world, x2, y2, z2, world.getBlockMetadata(x2, y2, z2));
                    world.setBlockWithNotify(x2, y2, z2, 0);
                    break;
                }
                return false;
            }
            if (Block.blocksList[i2].getMobilityFlag() == 1) break;
            if (l1 == 12) {
                return false;
            }
            x1 += PistonModel.xOffset[meta % 6];
            y1 += PistonModel.yOffset[meta % 6];
            z1 += PistonModel.zOffset[meta % 6];
        }
        return true;
    }

    private boolean tryExtend(World world, int x, int y, int z, int meta) {
        int i1 = x + PistonModel.xOffset[meta % 6];
        int j1 = y + PistonModel.yOffset[meta % 6];
        int k1 = z + PistonModel.zOffset[meta % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= Minecraft.WORLD_HEIGHT_BLOCKS - 1) {
                return false;
            }
            int j2 = world.getBlockId(i1, j1, k1);
            if (j2 == 0) break;
            if (!BlockPistonBase.canPushBlock(j2, world, i1, j1, k1, true)) {
                return false;
            }
            if (Block.blocksList[j2].getMobilityFlag() == 1) {
                Block.blocksList[j2].dropBlockAsItem(world, i1, j1, k1, world.getBlockMetadata(i1, j1, k1));
                world.setBlockWithNotify(i1, j1, k1, 0);
                break;
            }
            if (l1 == 12) {
                return false;
            }
            i1 += PistonModel.xOffset[meta % 6];
            j1 += PistonModel.yOffset[meta % 6];
            k1 += PistonModel.zOffset[meta % 6];
        }
        int l2 = 0;
        while (i1 != x || j1 != y || k1 != z) {
            int i2 = i1 - PistonModel.xOffset[meta % 6];
            int k2 = j1 - PistonModel.yOffset[meta % 6];
            l2 = k1 - PistonModel.zOffset[meta % 6];
            int i3 = world.getBlockId(i2, k2, l2);
            int j3 = world.getBlockMetadata(i2, k2, l2);
            if (i3 == this.blockID && i2 == x && k2 == y && l2 == z) {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.blockID, meta | (this.isSticky ? 8 : 0));
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.func_31036_a(Block.pistonHead.blockID, meta | (this.isSticky ? 8 : 0), meta, true, false));
            } else {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.blockID, j3);
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.func_31036_a(i3, j3, meta, true, false));
            }
            i1 = i2;
            j1 = k2;
            k1 = l2;
        }
        return true;
    }
}

