/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.Colors;

public class BlockPlanksPainted
extends Block {
    public BlockPlanksPainted(int id) {
        super(id, Material.wood);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        return this.getRenderColor(meta);
    }

    @Override
    public int getRenderColor(int i) {
        try {
            return Colors.allPlankColors[i % 16].getARGB();
        }
        catch (Exception e) {
            return 0xFF00FF;
        }
    }

    @Override
    public int damageDropped(int i) {
        return i;
    }

    public static int getMetadataForColour(int i) {
        return ~i & 0xF;
    }
}

