/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockBreakable;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockPortal
extends BlockBreakable {
    public int targetDimension;
    public int portalMaterialId;
    public int portalTriggerId;

    public BlockPortal(int id, int targetDimension, int portalMaterialId, int portalTriggerId) {
        super(id, Material.portal, false);
        this.targetDimension = targetDimension;
        this.portalMaterialId = portalMaterialId;
        this.portalTriggerId = portalTriggerId;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        if ((meta & 1) > 0) {
            float f1 = 0.125f;
            float f3 = 0.5f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f3, 0.5f + f1, 1.0f, 0.5f + f3);
        } else {
            float f = 0.5f;
            float f2 = 0.125f;
            this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f2, 0.5f + f, 1.0f, 0.5f + f2);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public int[] getPortalDims(World world, int x, int y, int z) {
        return this.getPortalDims(world, x, y, z, false);
    }

    public int[] getPortalDims(World world, int x, int y, int z, boolean swapOrientation) {
        int rz;
        int rx;
        int ry;
        int maxDims = 32;
        int ox = x;
        int oy = y;
        int oz = z;
        int maxBoundA = 0;
        int maxBoundY = 0;
        boolean foundBottom = false;
        boolean foundOrientation = false;
        boolean orientation = false;
        if (world.dimension.portalBlockId != -1 && world.dimension.portalBlockId != this.blockID) {
            return null;
        }
        for (ry = 0; ry > -maxDims; --ry) {
            if (world.getBlockId(x, y + ry, z) != this.portalMaterialId) continue;
            foundBottom = true;
            y += ry;
            break;
        }
        if (!foundBottom) {
            return null;
        }
        ++y;
        if (!swapOrientation) {
            for (rx = 0; rx > -maxDims; --rx) {
                if (world.getBlockId(x + rx, y, z) != this.portalMaterialId) continue;
                foundOrientation = true;
                orientation = false;
                x += rx;
                break;
            }
            if (!foundOrientation) {
                for (rz = 0; rz > -maxDims; --rz) {
                    if (world.getBlockId(x, y, z + rz) != this.portalMaterialId) continue;
                    foundOrientation = true;
                    orientation = true;
                    z += rz;
                    break;
                }
            }
        } else {
            for (rz = 0; rz > -maxDims; --rz) {
                if (world.getBlockId(x, y, z + rz) != this.portalMaterialId) continue;
                foundOrientation = true;
                orientation = true;
                z += rz;
                break;
            }
            if (!foundOrientation) {
                for (rx = 0; rx > -maxDims; --rx) {
                    if (world.getBlockId(x + rx, y, z) != this.portalMaterialId) continue;
                    foundOrientation = true;
                    orientation = false;
                    x += rx;
                    break;
                }
            }
        }
        if (!foundOrientation) {
            return null;
        }
        if (!orientation) {
            for (rx = 1; rx < maxDims; ++rx) {
                if (world.getBlockId(x + rx, y, z) != this.portalMaterialId) continue;
                maxBoundA = rx;
                break;
            }
        } else {
            for (rz = 1; rz < maxDims; ++rz) {
                if (world.getBlockId(x, y, z + rz) != this.portalMaterialId) continue;
                maxBoundA = rz;
                break;
            }
        }
        if (maxBoundA == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true);
        }
        --y;
        for (ry = 1; ry < maxDims; ++ry) {
            if (y + ry >= Minecraft.WORLD_HEIGHT_BLOCKS) {
                return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true);
            }
            if (world.getBlockId(x + (!orientation ? 1 : 0), y + ry, z + (orientation ? 1 : 0)) != this.portalMaterialId) continue;
            maxBoundY = ry;
            break;
        }
        if (maxBoundY == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true);
        }
        for (int ra = 0; ra <= maxBoundA; ++ra) {
            for (int ry2 = 0; ry2 <= maxBoundY; ++ry2) {
                int id;
                if (!(ra == 0 || ra == maxBoundA || ry2 == 0 || ry2 == maxBoundY ? world.getBlockId(x + (!orientation ? ra : 0), y + ry2, z + (orientation ? ra : 0)) != this.portalMaterialId : (id = world.getBlockId(x + (!orientation ? ra : 0), y + ry2, z + (orientation ? ra : 0))) != 0 && id != this.portalTriggerId && id != this.blockID)) continue;
                return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true);
            }
        }
        return new int[]{orientation ? 1 : 0, x, y, z, maxBoundA, maxBoundY};
    }

    public boolean tryToCreatePortal(World world, int x, int y, int z) {
        int[] bounds = this.getPortalDims(world, x, y, z);
        if (bounds == null) {
            return false;
        }
        x = bounds[1];
        y = bounds[2];
        z = bounds[3];
        world.editingBlocks = true;
        for (int ra = 1; ra < bounds[4]; ++ra) {
            for (int ry = 1; ry < bounds[5]; ++ry) {
                world.setBlockAndMetadata(x + (bounds[0] == 0 ? ra : 0), y + ry, z + (bounds[0] == 1 ? ra : 0), this.blockID, bounds[0] & 1);
            }
        }
        world.setBlockMetadata(x + (bounds[0] == 0 ? 1 : 0), y + 1, z + (bounds[0] == 1 ? 1 : 0), bounds[0] & 0xF | 2);
        world.markBlocksDirty(x + (bounds[0] == 0 ? 1 : 0), y + 1, z + (bounds[0] == 1 ? 1 : 0), x + (bounds[0] == 0 ? bounds[4] : 0), y + bounds[5], z + (bounds[0] == 1 ? bounds[4] : 0));
        world.editingBlocks = false;
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int id) {
        int[] bounds = this.getPortalDims(world, x, y, z);
        if (bounds == null) {
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag5;
        if (iblockaccess.getBlockId(i, j, k) == this.blockID) {
            return false;
        }
        boolean flag = iblockaccess.getBlockId(i - 1, j, k) == this.blockID && iblockaccess.getBlockId(i - 2, j, k) != this.blockID;
        boolean flag1 = iblockaccess.getBlockId(i + 1, j, k) == this.blockID && iblockaccess.getBlockId(i + 2, j, k) != this.blockID;
        boolean flag2 = iblockaccess.getBlockId(i, j, k - 1) == this.blockID && iblockaccess.getBlockId(i, j, k - 2) != this.blockID;
        boolean flag3 = iblockaccess.getBlockId(i, j, k + 1) == this.blockID && iblockaccess.getBlockId(i, j, k + 2) != this.blockID;
        boolean flag4 = flag || flag1;
        boolean bl = flag5 = flag2 || flag3;
        if (flag4 && l == 4) {
            return true;
        }
        if (flag4 && l == 5) {
            return true;
        }
        if (flag5 && l == 2) {
            return true;
        }
        return flag5 && l == 3;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (entity.ridingEntity == null && entity.riddenByEntity == null) {
            entity.setInPortal(this.blockID);
        }
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int meta = world.getBlockMetadata(i, j, k);
        if ((meta & 2) > 0 && random.nextInt(20) == 0) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "portal.portal", 0.5f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int l = 0; l < 4; ++l) {
            double d = (float)i + random.nextFloat();
            double d1 = (float)j + random.nextFloat();
            double d2 = (float)k + random.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int i1 = random.nextInt(2) * 2 - 1;
            d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            if (world.getBlockId(i - 1, j, k) == this.blockID || world.getBlockId(i + 1, j, k) == this.blockID) {
                d2 = (double)k + 0.5 + 0.25 * (double)i1;
                d5 = random.nextFloat() * 2.0f * (float)i1;
            } else {
                d = (double)i + 0.5 + 0.25 * (double)i1;
                d3 = random.nextFloat() * 2.0f * (float)i1;
            }
            world.spawnParticle("portal", d, d1, d2, d3, d4, d5);
        }
    }
}

