/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.RailLogic;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockRail
extends Block {
    private final boolean isPowered;

    public static final boolean isRailBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == Block.rail.blockID || l == Block.railPowered.blockID || l == Block.railDetector.blockID;
    }

    public static final boolean isRailBlock(int i) {
        return i == Block.rail.blockID || i == Block.railPowered.blockID || i == Block.railDetector.blockID;
    }

    protected BlockRail(int i, boolean flag) {
        super(i, Material.circuits);
        this.isPowered = flag;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    @Override
    public int getBlockOverbright(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this.blockID != Block.railPowered.blockID || (iblockaccess.getBlockMetadata(i, j, k) & 8) == 0) {
            return -1;
        }
        return BlockRail.texCoordToIndex(0, 16);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (this.isPowered) {
            if (this.blockID == Block.railPowered.blockID && (j & 8) == 0) {
                return BlockRail.texCoordToIndex(3, 10);
            }
            if (this.blockID == Block.railPowered.blockID) {
                return BlockRail.texCoordToIndex(3, 11);
            }
        } else if (j >= 6) {
            return BlockRail.texCoordToIndex(0, 7);
        }
        return BlockRail.texCoordToIndex(0, 8);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 9;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 1;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return world.canPlaceOnSurfaceOfBlock(i, j - 1, k);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.isMultiplayerAndNotHost) {
            this.func_4031_h(world, i, j, k, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag;
        int i1;
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int j1 = i1 = world.getBlockMetadata(i, j, k);
        if (this.isPowered) {
            j1 &= 7;
        }
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(i, j - 1, k);
        if (j1 == 2 && !world.canPlaceOnSurfaceOfBlock(i + 1, j, k)) {
            flag = true;
        }
        if (j1 == 3 && !world.canPlaceOnSurfaceOfBlock(i - 1, j, k)) {
            flag = true;
        }
        if (j1 == 4 && !world.canPlaceOnSurfaceOfBlock(i, j, k - 1)) {
            flag = true;
        }
        if (j1 == 5 && !world.canPlaceOnSurfaceOfBlock(i, j, k + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        } else if (this.blockID == Block.railPowered.blockID) {
            boolean flag1 = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
            flag1 = flag1 || this.func_27044_a(world, i, j, k, i1, true, 0) || this.func_27044_a(world, i, j, k, i1, false, 0);
            boolean flag2 = false;
            if (flag1 && (i1 & 8) == 0) {
                world.setBlockMetadataWithNotify(i, j, k, j1 | 8);
                flag2 = true;
            } else if (!flag1 && (i1 & 8) != 0) {
                world.setBlockMetadataWithNotify(i, j, k, j1);
                flag2 = true;
            }
            if (flag2) {
                world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
                if (j1 == 2 || j1 == 3 || j1 == 4 || j1 == 5) {
                    world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
                }
            }
        } else if (l > 0 && Block.blocksList[l].canProvidePower() && !this.isPowered && RailLogic.getNAdjacentTracks(new RailLogic(this, world, i, j, k)) == 3) {
            this.func_4031_h(world, i, j, k, false);
        }
    }

    private void func_4031_h(World world, int i, int j, int k, boolean flag) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        new RailLogic(this, world, i, j, k).func_792_a(world.isBlockIndirectlyGettingPowered(i, j, k), flag);
    }

    private boolean func_27044_a(World world, int i, int j, int k, int l, boolean flag, int i1) {
        if (i1 >= 8) {
            return false;
        }
        int j1 = l & 7;
        boolean flag1 = true;
        switch (j1) {
            case 0: {
                if (flag) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (flag) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (flag) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag1 = false;
                }
                j1 = 1;
                break;
            }
            case 3: {
                if (flag) {
                    --i;
                    ++j;
                    flag1 = false;
                } else {
                    ++i;
                }
                j1 = 1;
                break;
            }
            case 4: {
                if (flag) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag1 = false;
                }
                j1 = 0;
                break;
            }
            case 5: {
                if (flag) {
                    ++k;
                    ++j;
                    flag1 = false;
                } else {
                    --k;
                }
                j1 = 0;
            }
        }
        if (this.func_27043_a(world, i, j, k, flag, i1, j1)) {
            return true;
        }
        return flag1 && this.func_27043_a(world, i, j - 1, k, flag, i1, j1);
    }

    private boolean func_27043_a(World world, int i, int j, int k, boolean flag, int l, int i1) {
        int j1 = world.getBlockId(i, j, k);
        if (j1 == Block.railPowered.blockID) {
            int k1 = world.getBlockMetadata(i, j, k);
            int l1 = k1 & 7;
            if (i1 == 1 && (l1 == 0 || l1 == 4 || l1 == 5)) {
                return false;
            }
            if (i1 == 0 && (l1 == 1 || l1 == 2 || l1 == 3)) {
                return false;
            }
            if ((k1 & 8) != 0) {
                if (world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k)) {
                    return true;
                }
                return this.func_27044_a(world, i, j, k, k1, flag, l + 1);
            }
        }
        return false;
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    static boolean isPoweredBlockRail(BlockRail blockrail) {
        return blockrail.isPowered;
    }
}

