/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockRedstoneRepeater
extends Block {
    public static final double[] field_22024_a = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] field_22023_b = new int[]{1, 2, 3, 4};
    private final boolean isRepeaterPowered;

    public BlockRedstoneRepeater(int i, boolean flag) {
        super(i, Material.circuits);
        this.isRepeaterPowered = flag;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (!world.canPlaceOnSurfaceOfBlock(i, j - 1, k)) {
            return false;
        }
        return super.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        if (!world.canPlaceOnSurfaceOfBlock(i, j - 1, k)) {
            return false;
        }
        return super.canBlockStay(world, i, j, k);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        boolean flag = this.func_22022_g(world, i, j, k, l);
        if (this.isRepeaterPowered && !flag) {
            world.setBlockAndMetadataWithNotify(i, j, k, Block.repeaterIdle.blockID, l);
        } else if (!this.isRepeaterPowered) {
            world.setBlockAndMetadataWithNotify(i, j, k, Block.repeaterActive.blockID, l);
            if (!flag) {
                int i1 = (l & 0xC) >> 2;
                world.scheduleBlockUpdate(i, j, k, Block.repeaterActive.blockID, field_22023_b[i1] * 2);
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 0) {
            return !this.isRepeaterPowered ? BlockRedstoneRepeater.texCoordToIndex(3, 7) : BlockRedstoneRepeater.texCoordToIndex(3, 6);
        }
        if (i == 1) {
            return !this.isRepeaterPowered ? BlockRedstoneRepeater.texCoordToIndex(3, 8) : BlockRedstoneRepeater.texCoordToIndex(3, 9);
        }
        return BlockRedstoneRepeater.texCoordToIndex(5, 0);
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return l != 0 && l != 1;
    }

    @Override
    public int getRenderType() {
        return 15;
    }

    @Override
    public int getBlockTextureFromSide(int i) {
        return this.getBlockTextureFromSideAndMetadata(i, 0);
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int i1 = iblockaccess.getBlockMetadata(i, j, k) & 3;
        if (i1 == 0 && l == 3) {
            return true;
        }
        if (i1 == 1 && l == 4) {
            return true;
        }
        if (i1 == 2 && l == 2) {
            return true;
        }
        return i1 == 3 && l == 5;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = this.func_22022_g(world, i, j, k, i1);
        int j1 = (i1 & 0xC) >> 2;
        if (this.isRepeaterPowered && !flag) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, field_22023_b[j1] * 2);
        } else if (!this.isRepeaterPowered && flag) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, field_22023_b[j1] * 2);
        }
    }

    private boolean func_22022_g(World world, int i, int j, int k, int l) {
        int i1 = l & 3;
        switch (i1) {
            case 0: {
                return world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3) || world.getBlockId(i, j, k + 1) == Block.wireRedstone.blockID && world.getBlockMetadata(i, j, k + 1) > 0;
            }
            case 2: {
                return world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2) || world.getBlockId(i, j, k - 1) == Block.wireRedstone.blockID && world.getBlockMetadata(i, j, k - 1) > 0;
            }
            case 3: {
                return world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5) || world.getBlockId(i + 1, j, k) == Block.wireRedstone.blockID && world.getBlockMetadata(i + 1, j, k) > 0;
            }
            case 1: {
                return world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4) || world.getBlockId(i - 1, j, k) == Block.wireRedstone.blockID && world.getBlockMetadata(i - 1, j, k) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = (l & 0xC) >> 2;
        i1 = i1 + 1 << 2 & 0xC;
        world.setBlockMetadataWithNotify(i, j, k, i1 | l & 3);
        return true;
    }

    @Override
    public boolean canProvidePower() {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int l = player.getHorizontalPlacementDirection((Direction)side).getOpposite().index;
        world.setBlockMetadataWithNotify(x, y, z, l);
        boolean flag = this.func_22022_g(world, x, y, z, l);
        if (flag) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.repeater.itemID;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        double d = (double)((float)i + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)j + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)k + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d3 = 0.0;
        double d4 = 0.0;
        if (random.nextInt(2) == 0) {
            switch (l & 3) {
                case 0: {
                    d4 = -0.3125;
                    break;
                }
                case 2: {
                    d4 = 0.3125;
                    break;
                }
                case 3: {
                    d3 = -0.3125;
                    break;
                }
                case 1: {
                    d3 = 0.3125;
                }
            }
        } else {
            int i1 = (l & 0xC) >> 2;
            switch (l & 3) {
                case 0: {
                    d4 = field_22024_a[i1];
                    break;
                }
                case 2: {
                    d4 = -field_22024_a[i1];
                    break;
                }
                case 3: {
                    d3 = field_22024_a[i1];
                    break;
                }
                case 1: {
                    d3 = -field_22024_a[i1];
                }
            }
        }
        world.spawnParticle("reddust", d + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
    }
}

