/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.Sides;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public abstract class BlockRotatable
extends Block {
    public BlockRotatable(int i, Material material) {
        super(i, material);
    }

    public void setDefaultDirection(World world, int i, int j, int k) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, byte0);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int l = player.getHorizontalPlacementDirection((Direction)side).index;
        if (l == 0) {
            world.setBlockMetadataWithNotify(x, y, z, 2);
        }
        if (l == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 5);
        }
        if (l == 2) {
            world.setBlockMetadataWithNotify(x, y, z, 3);
        }
        if (l == 3) {
            world.setBlockMetadataWithNotify(x, y, z, 4);
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        int index = Sides.orientationLookUp[6 * meta + side];
        return this.atlasIndices[index];
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }
}

