/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSand
extends Block {
    public static boolean fallInstantly = false;

    public BlockSand(int i) {
        super(i, Material.sand);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        this.tryToFall(world, i, j, k);
    }

    private void tryToFall(World world, int i, int j, int k) {
        int l = i;
        int i1 = j;
        int j1 = k;
        if (BlockSand.canFallBelow(world, l, i1 - 1, j1) && i1 >= 0) {
            int byte0 = 32;
            if (fallInstantly || !world.checkChunksExist(i - byte0, j - byte0, k - byte0, i + byte0, j + byte0, k + byte0)) {
                world.setBlockWithNotify(i, j, k, 0);
                while (BlockSand.canFallBelow(world, i, j - 1, k) && j > 0) {
                    --j;
                }
                if (j > 0) {
                    world.setBlockWithNotify(i, j, k, this.blockID);
                }
            } else {
                EntityFallingSand entityfallingsand = new EntityFallingSand(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, this.blockID);
                world.entityJoinedWorld(entityfallingsand);
            }
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }

    public static boolean canFallBelow(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        if (l == 0) {
            return true;
        }
        if (l == Block.fire.blockID) {
            return true;
        }
        Material material = Block.blocksList[l].blockMaterial;
        if (material == Material.water) {
            return true;
        }
        return material == Material.lava;
    }
}

