/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class BlockSign
extends BlockContainer {
    private Class signEntityClass;
    private boolean isFreestanding;

    public BlockSign(int i, Class class1, boolean flag) {
        super(i, Material.wood);
        this.isFreestanding = flag;
        this.signEntityClass = class1;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        if (this.isFreestanding) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (l == 2) {
            this.setBlockBounds(f2, f, 1.0f - f4, f3, f1, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(f2, f, 0.0f, f3, f1, f4);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f4, f, f2, 1.0f, f1, f3);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, f, f2, f4, f1, f3);
        }
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        try {
            return (TileEntity)this.signEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.sign.itemID;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag = false;
        if (this.isFreestanding) {
            if (!world.getBlockMaterial(i, j - 1, k).isSolid()) {
                flag = true;
            }
        } else {
            int i1 = world.getBlockMetadata(i, j, k);
            flag = true;
            if (i1 == 2 && world.getBlockMaterial(i, j, k + 1).isSolid()) {
                flag = false;
            }
            if (i1 == 3 && world.getBlockMaterial(i, j, k - 1).isSolid()) {
                flag = false;
            }
            if (i1 == 4 && world.getBlockMaterial(i + 1, j, k).isSolid()) {
                flag = false;
            }
            if (i1 == 5 && world.getBlockMaterial(i - 1, j, k).isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }
}

